/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class BackpackContainerContents {
    public static final BackpackContainerContents EMPTY = new BackpackContainerContents((class_2371<class_1799>)class_2371.method_10213((int)27, (Object)class_1799.field_8037));
    public static final Codec<BackpackContainerContents> CODEC = Slot.CODEC.sizeLimitedListOf(256).xmap(BackpackContainerContents::fromSlots, BackpackContainerContents::asSlots);
    public static final class_9139<class_9129, BackpackContainerContents> STREAM_CODEC = class_1799.field_49268.method_56433(class_9135.method_58000((int)256)).method_56432(BackpackContainerContents::new, containerContents -> containerContents.items);
    private final class_2371<class_1799> items;
    private final int hashCode;

    private BackpackContainerContents(class_2371<class_1799> pItems) {
        if (pItems.size() > 256) {
            throw new IllegalArgumentException("Got " + pItems.size() + " items, but maximum is 256");
        }
        this.items = pItems;
        this.hashCode = class_1799.method_57361(pItems);
    }

    public BackpackContainerContents(int pSize) {
        this((class_2371<class_1799>)class_2371.method_10213((int)pSize, (Object)class_1799.field_8037));
    }

    private BackpackContainerContents(List<class_1799> stacks) {
        this(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.items.set(i, (Object)stacks.get(i));
        }
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    private static BackpackContainerContents fromSlots(List<Slot> slots) {
        OptionalInt optionalint = slots.stream().mapToInt(Slot::index).max();
        if (optionalint.isEmpty()) {
            return EMPTY;
        }
        BackpackContainerContents contents = new BackpackContainerContents(optionalint.getAsInt() + 1);
        for (Slot slot : slots) {
            contents.items.set(slot.index(), (Object)slot.item());
        }
        return contents;
    }

    public static BackpackContainerContents fromItems(int size, List<class_1799> pItems) {
        BackpackContainerContents contents = new BackpackContainerContents(size);
        for (int j = 0; j < size; ++j) {
            contents.items.set(j, (Object)pItems.get(j).method_7972());
        }
        return contents;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemstack = (class_1799)this.items.get(i);
            list.add(new Slot(i, itemstack));
        }
        return list;
    }

    public static BackpackContainerContents updateSlot(BackpackContainerContents oldContents, Slot slot) {
        class_2371 itemsCopy = class_2371.method_10213((int)oldContents.items.size(), (Object)class_1799.field_8037);
        oldContents.copyInto((class_2371<class_1799>)itemsCopy);
        if (slot.index >= 0 && slot.index < itemsCopy.size()) {
            itemsCopy.set(slot.index, (Object)slot.item.method_7972());
        }
        return BackpackContainerContents.fromItems(itemsCopy.size(), (List<class_1799>)itemsCopy);
    }

    public void copyInto(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            class_1799 itemstack = i < this.items.size() ? (class_1799)this.items.get(i) : class_1799.field_8037;
            list.set(i, (Object)itemstack.method_7972());
        }
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof BackpackContainerContents) {
            BackpackContainerContents contents = (BackpackContainerContents)pOther;
            if (class_1799.method_57362(this.items, contents.items)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public record Slot(int index, class_1799 item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(Slot::index), (App)class_1799.field_49266.fieldOf("item").forGetter(Slot::item)).apply((Applicative)inst, Slot::new));
    }
}

