/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FluidVariantWrapper(FluidVariant fluidVariant, long amount) {
    public static final Codec<FluidVariantWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidVariant.CODEC.fieldOf("fluidVariant").forGetter(FluidVariantWrapper::fluidVariant), (App)Codec.LONG.fieldOf("amount").forGetter(FluidVariantWrapper::amount)).apply((Applicative)instance, FluidVariantWrapper::new));
    public static final class_9139<class_9129, FluidVariantWrapper> STREAM_CODEC = class_9139.method_56435((class_9139)FluidVariant.PACKET_CODEC, FluidVariantWrapper::fluidVariant, (class_9139)class_9135.field_48551, FluidVariantWrapper::amount, FluidVariantWrapper::new);

    public static Optional<FluidVariantWrapper> parse(class_7225.class_7874 provider, class_2520 tag) {
        return CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).result();
    }

    public static FluidVariantWrapper parseOptional(class_7225.class_7874 provider, class_2520 tag) {
        return FluidVariantWrapper.parse(provider, tag).isPresent() ? FluidVariantWrapper.parse(provider, tag).get() : FluidVariantWrapper.blank();
    }

    public Optional<class_2520> save(class_7225.class_7874 provider) {
        return CODEC.encode((Object)this, (DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2487()).resultOrPartial(p_330104_ -> TravelersBackpack.LOGGER.error("Tried to save invalid FluidVariantWrapper: '{}'", p_330104_));
    }

    public class_2520 saveOptional(class_7225.class_7874 provider) {
        return this.save(provider).isPresent() ? this.save(provider).get() : new class_2487();
    }

    public boolean isEmpty() {
        return this.fluidVariant.isBlank() || this.amount <= 0L;
    }

    public long getAmount() {
        return this.amount;
    }

    public static FluidVariantWrapper blank() {
        return new FluidVariantWrapper(FluidVariant.blank(), 0L);
    }

    public FluidVariantWrapper copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return FluidVariantWrapper.blank();
        }
        if (amount <= 0L) {
            return FluidVariantWrapper.blank();
        }
        FluidVariantWrapper fluidVariant = this.copy();
        fluidVariant.setAmount(amount);
        return fluidVariant;
    }

    public FluidVariantWrapper copy() {
        if (this.isEmpty()) {
            return FluidVariantWrapper.blank();
        }
        return new FluidVariantWrapper(this.fluidVariant, this.amount);
    }

    public FluidVariantWrapper setAmount(long amount) {
        return new FluidVariantWrapper(this.fluidVariant, amount);
    }

    public FluidVariantWrapper grow(long addedAmount) {
        return this.setAmount(this.getAmount() + addedAmount);
    }

    public FluidVariantWrapper shrink(long removedAmount) {
        return this.grow(-removedAmount);
    }
}

