/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncComponentsPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.UnknownNullability;

public class TravelersBackpackSerializable
implements ITravelersBackpack,
INBTSerializable<CompoundTag> {
    public final Player player;
    public BackpackWrapper backpackWrapper;
    public ItemStack backpack = new ItemStack((ItemLike)Items.AIR, 0);

    public TravelersBackpackSerializable(IAttachmentHolder holder) {
        this.player = (Player)holder;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.getItem() instanceof TravelersBackpackItem;
    }

    @Override
    public ItemStack getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(ItemStack stack) {
        this.remove();
        if (!(stack.getItem() instanceof TravelersBackpackItem)) {
            return;
        }
        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, 2, this.player, this.player.level());
        this.backpackWrapper.setBackpackOwner(this.player);
        this.synchronise();
    }

    @Override
    public void updateBackpack(ItemStack stack) {
        if (this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);
        } else {
            this.equipBackpack(stack);
        }
    }

    @Override
    public void applyComponents(DataComponentMap map) {
        if (this.backpackWrapper != null) {
            this.backpack.applyComponents(map);
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeWearable() {
        this.backpack = new ItemStack((ItemLike)Items.AIR, 0);
    }

    @Override
    public void removeWrapper() {
        if (this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove() {
        this.removeWearable();
        this.removeWrapper();
        if (this.player.level() != null && !this.player.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.player, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(this.player.getId(), this.backpack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise() {
        if (this.player != null && !this.player.level().isClientSide) {
            AttachmentUtils.getAttachment(this.player).ifPresent(cap -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.player, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(this.player.getId(), this.backpack), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @Override
    public void synchronise(DataComponentMap map) {
        if (this.player != null && !this.player.level().isClientSide) {
            AttachmentUtils.getAttachment(this.player).ifPresent(cap -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.player, (CustomPacketPayload)new ClientboundSyncComponentsPacket(this.player.getId(), map), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        if (this.hasBackpack()) {
            ItemStack backpack = this.getBackpack();
            compound = (CompoundTag)backpack.saveOptional(provider);
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ItemStack backpack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt);
        this.equipBackpack(backpack);
    }
}

