/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientBackpackTooltipComponent
implements ClientTooltipComponent {
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public boolean show() {
        return KeyHelper.isCtrlPressed() || this.component.isHoveredWithItem();
    }

    public int getHeight() {
        int height = 0;
        if (this.show()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.upgrades.isEmpty()) {
                height += 10;
                height += 18;
            }
            if (!this.component.storage.isEmpty()) {
                height += 10;
                height += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                height += 10;
                height += 18;
            }
        }
        return height;
    }

    public int getWidth(Font font) {
        int width = 0;
        if (this.show() && !this.component.storage.isEmpty()) {
            width += Math.min(this.component.storage.size(), 9) * 18 + Math.min(this.component.storage.size(), 9) * 2;
        }
        return width;
    }

    public void renderText(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
        if (this.show()) {
            int yOffset = 0;
            if (!this.component.leftFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.leftFluidStack, pFont, pMouseX, pMouseY, pMatrix, (MultiBufferSource)pBufferSource);
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.rightFluidStack, pFont, pMouseX, pMouseY + yOffset, pMatrix, (MultiBufferSource)pBufferSource);
                yOffset += 10;
            }
            if (!this.component.upgrades.isEmpty()) {
                pFont.drawInBatch((Component)Component.translatable((String)"screen.travelersbackpack.upgrades"), (float)pMouseX, (float)pMouseY + (float)yOffset, ChatFormatting.YELLOW.getColor().intValue(), true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                yOffset += 10;
                yOffset += 18;
            }
            if (!this.component.storage.isEmpty()) {
                pFont.drawInBatch((Component)Component.translatable((String)"screen.travelersbackpack.inventory"), (float)pMouseX, (float)pMouseY + (float)yOffset, ChatFormatting.YELLOW.getColor().intValue(), true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                yOffset += 10;
                yOffset += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                pFont.drawInBatch((Component)Component.translatable((String)"screen.travelersbackpack.tools"), (float)pMouseX, (float)pMouseY + (float)yOffset, ChatFormatting.YELLOW.getColor().intValue(), true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                yOffset += 10;
                yOffset += 18;
            }
        }
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        int yOffset = 0;
        if (this.show()) {
            int i;
            if (!this.component.leftFluidStack.isEmpty()) {
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                yOffset += 10;
            }
            boolean flag = false;
            if (!this.component.upgrades.isEmpty()) {
                yOffset += 10;
                flag = true;
                for (i = 0; i < this.component.upgrades.size(); ++i) {
                    this.renderItem(this.component.upgrades.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
            if (!this.component.storage.isEmpty()) {
                yOffset += 10;
                int j = 0;
                if (flag) {
                    yOffset += 18;
                }
                flag = true;
                boolean nextRow = false;
                for (int i2 = 0; i2 < this.component.storage.size(); ++i2) {
                    if (nextRow) {
                        yOffset += 18;
                        nextRow = false;
                    }
                    this.renderItem(this.component.storage.get(i2), pX + j * 2 + j * 18, pY + yOffset, pFont, pGuiGraphics);
                    if (j < 8) {
                        ++j;
                        continue;
                    }
                    j = 0;
                    nextRow = true;
                }
            }
            if (!this.component.tools.isEmpty()) {
                yOffset += 10;
                if (flag) {
                    yOffset += 18;
                }
                for (i = 0; i < this.component.tools.size(); ++i) {
                    this.renderItem(this.component.tools.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
        }
    }

    private void renderItem(ItemStack stack, int pX, int pY, Font pFont, GuiGraphics guiGraphics) {
        guiGraphics.renderFakeItem(stack, pX, pY);
        guiGraphics.renderItemDecorations(pFont, stack, pX, pY);
    }

    public void renderFluidTankTooltip(FluidStack fluidStack, Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource bufferSource) {
        Component c = CommonFluid.getFluidName(fluidStack);
        MutableComponent c1 = Component.literal((String)": ");
        MutableComponent c2 = Component.literal((String)(fluidStack.getAmount() + "mB"));
        font.drawInBatch(c, (float)mouseX, (float)mouseY, -1, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch((Component)c1, (float)mouseX + (float)font.width((FormattedText)c), (float)mouseY, -1, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch((Component)c2, (float)mouseX + (float)font.width((FormattedText)c) + (float)font.width((FormattedText)c1), (float)mouseY, 0x5555FF, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

