/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackDynamicModel;
import com.tiviacz.travelersbackpack.client.renderer.BackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackItemStackRenderer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.PotionFluidType;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.fluids.FluidStack;

@EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    public static final String CATEGORY = "key.travelersbackpack.category";
    public static final KeyMapping OPEN_BACKPACK = new KeyMapping("key.travelersbackpack.inventory", 66, "key.travelersbackpack.category");
    public static final KeyMapping SORT_BACKPACK = new KeyMapping("key.travelersbackpack.sort", -1, "key.travelersbackpack.category");
    public static final KeyMapping ABILITY = new KeyMapping("key.travelersbackpack.ability", -1, "key.travelersbackpack.category");
    public static final KeyMapping SWAP_TOOL = new KeyMapping("key.travelersbackpack.cycle_tool", 90, "key.travelersbackpack.category");
    public static final KeyMapping TOGGLE_TANK = new KeyMapping("key.travelersbackpack.toggle_tank", 78, "key.travelersbackpack.category");
    public static final ModelResourceLocation STAR_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"item/supporter_star"));

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_BACKPACK);
        event.register(SORT_BACKPACK);
        event.register(ABILITY);
        event.register(SWAP_TOOL);
        event.register(TOGGLE_TANK);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModItems.BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(STAR_MODEL);
    }

    @SubscribeEvent
    public static void registerClientExtenstions(RegisterClientExtensionsEvent event) {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> event.registerItem(new IClientItemExtensions(){
            private final Supplier<BlockEntityWithoutLevelRenderer> renderer = () -> new BackpackItemStackRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer.get();
            }
        }, new Holder[]{holder}));
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final int EMPTY_COLOR = 0xF800F8;

            public int getTintColor() {
                return -524040;
            }

            public int getTintColor(FluidStack stack) {
                return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
            }

            public ResourceLocation getStillTexture() {
                return PotionFluidType.POTION_STILL_RL;
            }

            public ResourceLocation getFlowingTexture() {
                return PotionFluidType.POTION_FLOW_RL;
            }
        }, new Holder[]{ModFluids.POTION_FLUID_TYPE});
    }

    @SubscribeEvent
    public static void registerMenuScreensEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.BACKPACK_MENU.get(), BackpackScreen::new);
        event.register((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get(), BackpackScreen::new);
        event.register((MenuType)ModMenuTypes.BACKPACK_SETTINGS_MENU.get(), BackpackSettingsScreen::new);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"), (IGeometryLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiLayersEvent evt) {
        evt.registerBelow(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"overlay"), (pGuiGraphics, pPartialTick) -> {
            Minecraft mc = Minecraft.getInstance();
            if (((Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get()).booleanValue() && !mc.options.hideGui && AttachmentUtils.isWearingBackpack((Player)mc.player) && mc.gameMode.getPlayerMode() != GameType.SPECTATOR) {
                HudOverlay.renderOverlay(AttachmentUtils.getWearingBackpack((Player)mc.player), mc, pGuiGraphics);
            }
        });
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BackpackTooltipComponent.class, ClientBackpackTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, blockDisplayReader, pos, tintIndex) -> {
            BackpackBlockEntity backpack;
            if (tintIndex != 0 || pos == null) {
                return -1;
            }
            BlockEntity patt0$temp = blockDisplayReader.getBlockEntity(pos);
            if (patt0$temp instanceof BackpackBlockEntity && (backpack = (BackpackBlockEntity)patt0$temp).getWrapper().getBackpackStack().has(DataComponents.DYED_COLOR)) {
                return FastColor.ARGB32.opaque((int)((DyedItemColor)backpack.getWrapper().getBackpackStack().get(DataComponents.DYED_COLOR)).rgb());
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            if (stack.has(DataComponents.DYED_COLOR)) {
                return FastColor.ARGB32.opaque((int)((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb());
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get()});
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ModClientEventHandler.addPlayerLayer(evt, PlayerSkin.Model.WIDE);
        ModClientEventHandler.addPlayerLayer(evt, PlayerSkin.Model.SLIM);
        for (EntityType type : evt.getEntityTypes()) {
            LivingEntityRenderer livingEntityRenderer;
            EntityRenderer entityRenderer = evt.getRenderer(type);
            if (!(entityRenderer instanceof LivingEntityRenderer) || !((livingEntityRenderer = (LivingEntityRenderer)entityRenderer).getModel() instanceof HumanoidModel) || TravelersBackpack.endermanOverhaulLoaded && type == EntityType.ENDERMAN || livingEntityRenderer instanceof PlayerRenderer) continue;
            livingEntityRenderer.addLayer((RenderLayer)new BackpackEntityLayer((RenderLayerParent<LivingEntity, HumanoidModel<LivingEntity>>)livingEntityRenderer));
        }
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, PlayerSkin.Model model) {
        EntityRenderer renderer = evt.getSkin(model);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            livingRenderer.addLayer((RenderLayer)new BackpackLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)livingRenderer));
        }
    }

    public static void registerItemModelProperties() {
        ItemProperties.register((Item)((Item)ModItems.HOSE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"mode"), (stack, world, entity, propertyFunction) -> {
            if (stack.has(ModDataComponents.HOSE_MODES)) {
                int mode = (Integer)((List)stack.get(ModDataComponents.HOSE_MODES)).get(0);
                return (float)mode / 10.0f;
            }
            return 0.0f;
        });
    }
}

