/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackpackSettingsContainer
implements MenuProvider,
Nameable {
    public final ItemStack stack;
    public final Player player;
    public final int screenID;
    public final int index;

    public BackpackSettingsContainer(ItemStack stack, Player player, int screenID, int index) {
        this.stack = stack;
        this.player = player;
        this.screenID = screenID;
        this.index = index;
    }

    public Component getName() {
        return Component.translatable((String)"screen.travelersbackpack.item");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"screen.travelersbackpack.item");
    }

    public static RegistryFriendlyByteBuf saveSettingsExtraData(RegistryFriendlyByteBuf buf, int screenID, int index) {
        buf.writeBoolean(false);
        buf.writeInt(screenID);
        buf.writeBlockPos(BlockPos.ZERO);
        buf.writeInt(index);
        return buf;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.screenID == 2) {
            return new BackpackSettingsMenu(pContainerId, pPlayerInventory, AttachmentUtils.getBackpackWrapper(this.player));
        }
        return new BackpackSettingsMenu(pContainerId, pPlayerInventory, new BackpackWrapper(this.stack, this.screenID, pPlayer, pPlayer.level(), this.index));
    }

    public static void openSettings(ServerPlayer serverPlayerEntity, ItemStack stack, int screenID, int index) {
        if (!serverPlayerEntity.level().isClientSide) {
            serverPlayerEntity.openMenu((MenuProvider)new BackpackSettingsContainer(stack, (Player)serverPlayerEntity, screenID, index), buf -> BackpackSettingsContainer.saveSettingsExtraData(buf, screenID, index));
        }
    }
}

