/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class TanksUpgrade
extends UpgradeBase<TanksUpgrade> {
    private final ItemStackHandler fluidSlotsHandler = this.createTemporaryHandler();
    protected final FluidTank leftTank = this.createFluidHandler(1000);
    protected final FluidTank rightTank = this.createFluidHandler(1000);
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TanksUpgrade(UpgradeManager manager, int dataHolderSlot, Fluids fluids) {
        super(manager, dataHolderSlot, new Point(51, 72));
        this.setTanksCapacity();
        this.setFluids(fluids);
        this.leftTankPos = new Point(7, 15);
        this.rightTankPos = new Point(195 + (manager.getWrapper().isExtended() ? 36 : 0), 15);
        this.getUpgradeManager().getWrapper().setRenderInfo(this.writeToRenderData());
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlotsHandler;
    }

    public void setTanksCapacity() {
        this.leftTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
        this.rightTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
    }

    public void setFluids(Fluids tanks) {
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setFluid(tanks.rightFluidStack());
    }

    public void syncClients(ItemStack backpack) {
        int slot = this.getDataHolderSlot();
        BackpackContainerContents contents = (BackpackContainerContents)backpack.get(ModDataComponents.UPGRADES);
        if (contents == null) {
            return;
        }
        if (slot >= contents.getItems().size()) {
            return;
        }
        ItemStack stack = (ItemStack)contents.getItems().get(slot);
        this.setFluids((Fluids)stack.getOrDefault(ModDataComponents.FLUIDS, (Object)Fluids.empty()));
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TanksUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.FLUIDS.get(), new Fluids(TanksUpgrade.this.leftTank.getFluid(), TanksUpgrade.this.rightTank.getFluid()));
                TanksUpgrade.this.getUpgradeManager().getWrapper().setRenderInfo(TanksUpgrade.this.writeToRenderData());
                TanksUpgrade.this.getUpgradeManager().getWrapper().sendDataToClients((DataComponentType)ModDataComponents.RENDER_INFO.get(), (DataComponentType)ModDataComponents.UPGRADES.get());
            }
        };
    }

    public CompoundTag writeToRenderData() {
        CompoundTag tag = new CompoundTag();
        if (this.getUpgradeManager().getWrapper().getRegistriesAccess() != null) {
            tag.put("LeftTank", this.leftTank.getFluid().saveOptional((HolderLookup.Provider)this.getUpgradeManager().getWrapper().getRegistriesAccess()));
            tag.put("RightTank", this.rightTank.getFluid().saveOptional((HolderLookup.Provider)this.getUpgradeManager().getWrapper().getRegistriesAccess()));
        }
        tag.putInt("Capacity", this.leftTank.getCapacity());
        return tag;
    }

    @Override
    public void remove() {
        this.getUpgradeManager().getWrapper().removeRenderInfo();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new TankWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<SlotItemHandler> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<SlotItemHandler> slots = new ArrayList<SlotItemHandler>();
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 0, x + 7, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 1, x + 7, y + 49));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 2, x + 28, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 3, x + 28, y + 49));
        return slots;
    }

    public ItemStackHandler createTemporaryHandler() {
        return new ItemStackHandler(this, 4){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                Optional container = FluidUtil.getFluidHandler((ItemStack)stack);
                if (slot == 1 || slot == 3) {
                    return false;
                }
                if (stack.getItem() instanceof PotionItem || stack.getItem() == Items.GLASS_BOTTLE) {
                    return true;
                }
                return container.isPresent();
            }
        };
    }
}

