/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.util.LogHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BackpackDeathHelper {
    public static boolean onPlayerDrops(Level level, Player player, ItemStack stack) {
        if (!level.isClientSide) {
            BackpackManager.addBackpack((ServerPlayer)player, stack);
        }
        if (TravelersBackpack.isAnyGraveModInstalled()) {
            return true;
        }
        boolean drop = true;
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backpackDeathPlace.get()).booleanValue()) {
            drop = (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backpackForceDeathPlace.get() != false ? !BackpackDeathHelper.placeBackpack(level, player, player.blockPosition(), stack) : !BackpackDeathHelper.tryPlace(level, player, stack);
        }
        return drop;
    }

    private static boolean placeBackpack(Level level, Player player, BlockPos placePos, ItemStack stack) {
        Block block = Block.byItem((Item)stack.getItem());
        int y = placePos.getY();
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backpackForceDeathPlace.get()).booleanValue()) {
            BlockPos targetPos;
            BlockPos playerPos = player.blockPosition();
            y = playerPos.getY();
            if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.voidProtection.get()).booleanValue() && y <= level.getMinBuildHeight()) {
                y = level.getMinBuildHeight() + 5;
            }
            for (int i = y; i < level.getHeight(); ++i) {
                if (!level.getBlockState(new BlockPos(playerPos.getX(), i, playerPos.getZ())).isAir()) continue;
                y = i;
                break;
            }
            if (level.getBlockState(targetPos = new BlockPos(playerPos.getX(), y, playerPos.getZ())).getBlock().getExplosionResistance() > -1.0f) {
                while (level.getBlockEntity(targetPos) != null) {
                    targetPos = targetPos.above();
                }
                if (!level.setBlockAndUpdate(targetPos, block.defaultBlockState())) {
                    return false;
                }
                BackpackDeathHelper.placeBackpackInTheWorld(level, player, targetPos, block, stack);
                return true;
            }
            return false;
        }
        if (y <= level.getMinBuildHeight() || y >= level.getHeight()) {
            return false;
        }
        BlockPos targetPos = new BlockPos(placePos.getX(), y, placePos.getZ());
        if (!level.setBlockAndUpdate(targetPos, block.defaultBlockState())) {
            return false;
        }
        BackpackDeathHelper.placeBackpackInTheWorld(level, player, targetPos, block, stack);
        return true;
    }

    private static void placeBackpackInTheWorld(Level level, Player player, BlockPos targetPos, Block block, ItemStack stack) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundSendMessagePacket(false, targetPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        LogHelper.info("Your backpack has been placed at X: " + targetPos.getX() + " Y: " + targetPos.getY() + " Z: " + targetPos.getZ(), new Object[0]);
        level.playSound(player, (double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), block.defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
        TravelersBackpackItem.updateCustomBlockEntityTag(level, player, targetPos, stack);
        level.getBlockState(targetPos).getBlock().setPlacedBy(level, targetPos, level.getBlockState(targetPos), (LivingEntity)player, stack);
        ((BackpackBlockEntity)level.getBlockEntity(targetPos)).setBackpack(stack, (HolderLookup.Provider)level.registryAccess());
        if (AttachmentUtils.isWearingBackpack(player) && !level.isClientSide) {
            AttachmentUtils.getAttachment(player).ifPresent(ITravelersBackpack::remove);
        }
    }

    private static boolean tryPlace(Level level, Player player, ItemStack stack) {
        int[] positions;
        int X = (int)player.getX();
        int Z = (int)player.getZ();
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            BlockPos spawn;
            int y = (int)player.getY();
            if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.voidProtection.get()).booleanValue() && y <= level.getMinBuildHeight()) {
                y = level.getMinBuildHeight() + 5;
            }
            if ((spawn = BackpackDeathHelper.getNearestEmptyChunkCoordinatesSpiral(player, level, X, Z, new BlockPos(X, y + Y, Z), 12, true, 1, (byte)0)) == null) continue;
            return BackpackDeathHelper.placeBackpack(level, player, spawn, stack);
        }
        return false;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static BlockPos getNearestEmptyChunkCoordinatesSpiral(Player player, Level level, int origX, int origZ, BlockPos pos, int radius, boolean except, int steps, byte pass) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.getX(); i <= pos.getX() + steps; ++i) {
                    BlockPos blockPos = BackpackDeathHelper.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackDeathHelper.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.getY(), j), radius, except, steps, pass);
            }
            if (pass == 1) {
                for (j = pos.getZ(); j >= pos.getZ() - steps; --j) {
                    BlockPos blockPos = BackpackDeathHelper.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackDeathHelper.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.getY(), j), radius, except, ++steps, pass);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.getX() - steps) {
                    BlockPos blockPos = BackpackDeathHelper.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackDeathHelper.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.getY(), j), radius, except, steps, pass);
            }
            if (pass == 1) {
                while (j <= pos.getZ() + steps) {
                    BlockPos blockPos = BackpackDeathHelper.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackDeathHelper.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.getY(), j), radius, except, ++steps, pass);
            }
        }
        return null;
    }

    public static boolean isTopSolid(Level level, Player player, BlockPos pos) {
        return level.getBlockState(pos.below()).entityCanStandOn((BlockGetter)level, pos.below(), (Entity)player);
    }

    private static BlockPos checkCoordsForBackpack(Player player, Level level, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && BackpackDeathHelper.isTopSolid(level, player, pos) && (level.getBlockState(pos).isAir() || level.getBlockState(pos).canBeReplaced()) && !BackpackDeathHelper.areCoordinatesTheSame(new BlockPos(origX, pos.getY(), origZ), pos)) {
            return pos;
        }
        if (!except && BackpackDeathHelper.isTopSolid(level, player, pos) && (level.getBlockState(pos).isAir() || level.getBlockState(pos).canBeReplaced())) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(BlockPos pos1, BlockPos pos2) {
        return pos1 == pos2;
    }

    public static BlockPos findBlock3D(Level level, int x, int y, int z, Block block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (level.getBlockState(new BlockPos(j, i, k)).getBlock() != block) continue;
                    return new BlockPos(j, i, k);
                }
            }
        }
        return null;
    }
}

