/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.client.model.BackpackDynamicModel;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.List;
import java.util.Set;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackpackItemModel
implements ItemModel {
    public static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final ItemTransforms ITEM_TRANSFORMS = BackpackItemModel.createItemTransforms();
    private final BackpackDynamicModel.BlockStateModel baseModel;
    private final List<ItemTintSource> tintSources;
    private final Supplier<Vector3f[]> extents;

    private static ItemTransforms createItemTransforms() {
        return new ItemTransforms(new ItemTransform((Vector3fc)new Vector3f(60.0f, -180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.09375f, 0.03125f), (Vector3fc)new Vector3f(0.7f, 0.7f, 0.7f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(60.0f, -180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.09375f, 0.03125f), (Vector3fc)new Vector3f(0.7f, 0.7f, 0.7f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, -90.0f, 12.5f), (Vector3fc)new Vector3f(0.070625f, 0.375f, 0.125f), (Vector3fc)new Vector3f(0.68f, 0.68f, 0.68f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, -90.0f, 12.5f), (Vector3fc)new Vector3f(0.070625f, 0.375f, 0.125f), (Vector3fc)new Vector3f(0.68f, 0.68f, 0.68f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.90625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(30.0f, -38.0f, 0.0f), (Vector3fc)new Vector3f(-0.015625f, 0.140625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.125f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.140625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.140625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), ImmutableMap.of());
    }

    public BackpackItemModel(BackpackDynamicModel.BlockStateModel baseModel, List<ItemTintSource> tintSources) {
        this.baseModel = baseModel;
        this.tintSources = tintSources;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(baseModel.getQuads()));
    }

    public void update(ItemStackRenderState stackRenderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel clientLevel, @Nullable ItemOwner itemOwner, int seed) {
        stackRenderState.appendModelIdentityElement((Object)this);
        ItemStackRenderState.LayerRenderState renderLayer = stackRenderState.newLayer();
        if (stack.hasFoil()) {
            renderLayer.setFoilType(ItemStackRenderState.FoilType.STANDARD);
            stackRenderState.appendModelIdentityElement((Object)ItemStackRenderState.FoilType.STANDARD);
        }
        int k = this.tintSources.size();
        int[] aint = renderLayer.prepareTintLayers(k);
        for (int i = 0; i < k; ++i) {
            int j;
            aint[i] = j = this.tintSources.get(i).calculate(stack, clientLevel, itemOwner != null ? itemOwner.asLivingEntity() : null);
            stackRenderState.appendModelIdentityElement((Object)j);
        }
        this.setProperties(stack, stackRenderState);
        renderLayer.setExtents(this.extents);
        renderLayer.setUsesBlockLight(true);
        renderLayer.setParticleIcon(this.baseModel.particleIcon());
        renderLayer.setTransform(ITEM_TRANSFORMS.getTransform(displayContext));
        renderLayer.prepareQuadList().addAll(this.baseModel.getQuads());
        SpecialRenderer specialRenderer = new SpecialRenderer();
        specialRenderer.setModelRenderParameters(aint, this.baseModel.getQuads());
        renderLayer.setupSpecialModel((SpecialModelRenderer)specialRenderer, (Object)specialRenderer.extractArgument(stack));
    }

    private void setProperties(ItemStack stack, ItemStackRenderState stackRenderState) {
        BackpackDynamicModel.BlockStateModel blockStateModel = this.baseModel;
        if (blockStateModel instanceof BackpackDynamicModel.BlockStateModel) {
            BackpackDynamicModel.BlockStateModel backpackModel = blockStateModel;
            backpackModel.isDyed = stack.has(DataComponents.DYED_COLOR);
            backpackModel.renderInfo = (RenderInfo)stack.get(ModDataComponents.RENDER_INFO);
            backpackModel.sleepingBagColor = (Integer)stack.getOrDefault(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.RED.getId());
            backpackModel.isSleepingBagDeployed = false;
            backpackModel.block = Block.byItem((Item)stack.getItem());
            if (backpackModel.renderInfo != null) {
                stackRenderState.appendModelIdentityElement((Object)"RenderInfo");
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.hasTanks());
                stackRenderState.appendModelIdentityElement((Object)"LeftTank");
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.getLeftFluidStack().getFluid());
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.getLeftFluidStack().getComponents());
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.getLeftFluidStack().getAmount());
                stackRenderState.appendModelIdentityElement((Object)"RightTank");
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.getRightFluidStack().getFluid());
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.getRightFluidStack().getComponents());
                stackRenderState.appendModelIdentityElement((Object)backpackModel.renderInfo.getRightFluidStack().getAmount());
            }
            if (backpackModel.sleepingBagColor != DyeColor.RED.getId()) {
                stackRenderState.appendModelIdentityElement((Object)"SleepingBagColor");
                stackRenderState.appendModelIdentityElement((Object)backpackModel.sleepingBagColor);
            }
        }
    }

    public static class SpecialRenderer
    implements NoDataSpecialModelRenderer {
        private int[] tintLayers;
        private List<BakedQuad> baseModel;

        public void setModelRenderParameters(int[] tintLayers, List<BakedQuad> baseModel) {
            this.tintLayers = tintLayers;
            this.baseModel = baseModel;
        }

        public void getExtents(Set<Vector3f> set) {
        }

        public void submit(ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector collector, int combinedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
            collector.submitItem(poseStack, displayContext, combinedLight, packedOverlay, outlineColor, this.tintLayers, this.baseModel, Sheets.translucentItemSheet(), hasFoil ? ItemStackRenderState.FoilType.STANDARD : ItemStackRenderState.FoilType.NONE);
        }
    }

    public record Unbaked(ResourceLocation base, List<ItemTintSource> tintSources) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("base").forGetter(Unbaked::base), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tintSources", List.of()).forGetter(Unbaked::tintSources)).apply((Applicative)builder, Unbaked::new));

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ResolvedModel resolved = context.blockModelBaker().getModel(this.base);
            UnbakedModel unbakedModel = resolved.wrapped();
            if (unbakedModel instanceof BackpackDynamicModel) {
                BackpackDynamicModel baseModel = (BackpackDynamicModel)unbakedModel;
                return new BackpackItemModel(baseModel.bakeBlockStateModel(context.blockModelBaker(), resolved, (ModelState)BlockModelRotation.X0_Y0), this.tintSources);
            }
            throw new IllegalStateException("Expected BackpackDynamicModel, instead received " + resolved.getClass().getName());
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.base);
        }
    }
}

