/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.client.model.BackpackModelPart;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class StackModelPart
extends BackpackModelPart {
    private final ItemModelResolver resolver = Minecraft.getInstance().getItemModelResolver();
    private final ItemStackRenderState upper = new ItemStackRenderState();
    private final ItemStackRenderState lower = new ItemStackRenderState();

    public List<ItemStack> prepare(ItemStack stack) {
        if (stack.has(ModDataComponents.TOOLS_CONTAINER)) {
            return new ArrayList<ItemStack>((Collection<ItemStack>)((BackpackContainerContents)stack.get(ModDataComponents.TOOLS_CONTAINER)).getItems()).stream().filter(itemStack -> !itemStack.isEmpty()).toList();
        }
        return new ArrayList<ItemStack>();
    }

    public void render(ItemStack backpack, SubmitNodeCollector collector, PoseStack poseStack, int light, int overlay) {
        if (collector == null) {
            return;
        }
        this.render(this.prepare(backpack), poseStack, collector, light, overlay);
    }

    public void render(List<ItemStack> tools, PoseStack poseStack, SubmitNodeCollector collector, int pPackedLight, int pPackedOverlay) {
        if (tools.isEmpty()) {
            return;
        }
        ItemStack toolUpper = tools.get(0);
        ItemStack toolLower = ItemStack.EMPTY;
        if (!toolUpper.isEmpty() && tools.size() > 1) {
            toolLower = tools.get(tools.size() - 1);
        }
        if (!toolUpper.isEmpty()) {
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(0.04, 0.075, 0.17);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            this.resolver.updateForTopItem(this.upper, toolUpper, ItemDisplayContext.NONE, null, null, 0);
            this.upper.submit(poseStack, collector, pPackedLight, pPackedOverlay, 0);
            poseStack.popPose();
        }
        if (!toolLower.isEmpty()) {
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(-0.25, 0.75, -0.025);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            this.resolver.updateForTopItem(this.lower, toolLower, ItemDisplayContext.NONE, null, null, 0);
            this.lower.submit(poseStack, collector, pPackedLight, pPackedOverlay, 0);
            poseStack.popPose();
        }
    }
}

