/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.BackpackModel;
import com.tiviacz.travelersbackpack.client.model.StackModelPart;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;

public class BackpackLayer
extends RenderLayer<AvatarRenderState, PlayerModel> {
    public static final ContextKey<ItemStack> BACKPACK_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"));
    public static final ContextKey<String> NAME_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"name"));
    private static final BackpackModel BACKPACK_MODEL = new BackpackModel();
    private final StackModelPart tools = new StackModelPart();
    private final ItemStackRenderState backpackRenderState = new ItemStackRenderState();

    public BackpackLayer(RenderLayerParent<AvatarRenderState, PlayerModel> renderer) {
        super(renderer);
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector sumbitNodeCollector, int packedLightIn, AvatarRenderState state, float limbSwing, float limbSwingAmount) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        ItemStack backpack = (ItemStack)state.getRenderData(BACKPACK_KEY);
        if (backpack != null && backpack.getItem() instanceof TravelersBackpackItem) {
            BackpackLayer.renderBackpackLayer((HumanoidModel)this.getParentModel(), poseStack, sumbitNodeCollector, packedLightIn, (HumanoidRenderState)state, this.backpackRenderState, this.tools, backpack);
        }
    }

    public static void renderBackpackLayer(HumanoidModel humanoidModel, PoseStack poseStack, SubmitNodeCollector collector, int packedLightIn, HumanoidRenderState state, ItemStackRenderState backpackRenderState, StackModelPart tools, ItemStack stack) {
        if (!((Boolean)stack.getOrDefault(ModDataComponents.IS_VISIBLE, (Object)true)).booleanValue()) {
            return;
        }
        if (!(stack.getItem() instanceof TravelersBackpackItem)) {
            return;
        }
        poseStack.pushPose();
        BackpackLayer.alignModel(poseStack, humanoidModel, BACKPACK_MODEL, state);
        BACKPACK_MODEL.render(poseStack, packedLightIn, collector, backpackRenderState, tools, stack);
        if (state instanceof AvatarRenderState && Supporters.SUPPORTERS.contains(state.getRenderData(NAME_KEY))) {
            BackpackLayer.BACKPACK_MODEL.supporterBadgeModel.render(poseStack, packedLightIn);
        }
        poseStack.popPose();
    }

    public static void alignModel(PoseStack poseStack, HumanoidModel parent, BackpackModel backpackModel, HumanoidRenderState state) {
        backpackModel.copyFrom(parent.body);
        backpackModel.supporterBadgeModel.copyFrom(parent.body);
        if (state.isBaby) {
            poseStack.translate(0.0f, 0.8f, -0.165f);
            float scaleFactor = state.scale;
            poseStack.scale(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }
}

