/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;

public class UpgradeWidgetBase<U extends UpgradeBase>
extends WidgetBase<BackpackScreen> {
    private final WidgetElement removeElement;
    private final WidgetElement enableElement;
    protected U upgrade;
    protected int dataHolderSlot;
    protected final Point tabUv;
    private final String upgradeIconTooltip;

    public UpgradeWidgetBase(BackpackScreen screen, U upgrade, Point pos, Point tabUv, String upgradeIconTooltip) {
        super(screen, pos, 24, 24);
        this.upgrade = upgrade;
        this.dataHolderSlot = ((UpgradeBase)upgrade).getDataHolderSlot();
        this.tabUv = tabUv;
        this.upgradeIconTooltip = upgradeIconTooltip;
        this.width = ((UpgradeBase)upgrade).getTabSize().x();
        this.height = ((UpgradeBase)upgrade).getTabSize().y();
        this.removeElement = new WidgetElement(new Point(((UpgradeBase)this.upgrade).getTabSize().x() - 3 - 18, 3), new Point(18, 18));
        this.enableElement = new WidgetElement(new Point(((UpgradeBase)this.upgrade).getTabSize().x(), 6), new Point(4, 13));
    }

    public U getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isTabOpened()) {
            U u = this.upgrade;
            if (u instanceof IFilterSlots) {
                IFilterSlots filter = (IFilterSlots)u;
                int sizeX = this.width;
                int sizeY = this.height;
                boolean requiresWider = false;
                int splitY = sizeY / 2;
                int remY = sizeY - splitY;
                int tabUvWidth = 66;
                int tabUvHeight = 103;
                if (this.width > tabUvWidth) {
                    requiresWider = true;
                }
                if (requiresWider) {
                    int splitX = sizeX / 2;
                    int remX = sizeX - splitX;
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y(), (float)this.tabUv.x(), (float)this.tabUv.y(), splitX, splitY, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x() + splitX, this.pos.y(), (float)(this.tabUv.x() + tabUvWidth - remX), (float)this.tabUv.y(), remX, splitY, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y() + splitY, (float)this.tabUv.x(), (float)(this.tabUv.y() + tabUvHeight - remY), splitX, remY, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x() + splitX, this.pos.y() + splitY, (float)(this.tabUv.x() + tabUvWidth - remX), (float)(this.tabUv.y() + tabUvHeight - remY), remX, remY, 256, 256);
                } else {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y(), (float)this.tabUv.x(), (float)this.tabUv.y(), this.width, splitY, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y() + splitY, (float)this.tabUv.x(), (float)(this.tabUv.y() + tabUvHeight - remY), this.width, remY, 256, 256);
                }
                int slotOffset = this.hasButtons() ? 43 : 22;
                for (int i = 0; i < filter.getRows(); ++i) {
                    for (int j = 0; j < filter.getSlotsInRow(i); ++j) {
                        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x() + 6 + j * 18, this.pos.y() + slotOffset + i * 18, 233.0f, 0.0f, 18, 18, 256, 256);
                    }
                }
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y(), (float)this.tabUv.x(), (float)this.tabUv.y(), this.width, this.height, 256, 256);
            }
            guiGraphics.renderItem(((BackpackScreen)this.screen).getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), this.pos.x() + 4, this.pos.y() + 4);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderEnableButton(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isBackpackOwner()) {
            this.renderRemoveButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOverIcon(mouseX, mouseY)) {
            UpgradeItem upgradeItem;
            Item item;
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(Component.translatable((String)this.upgradeIconTooltip));
            if (((UpgradeBase)this.getUpgrade()).getUpgradeManager().getWrapper().getScreenID() != 2 && (item = ((UpgradeBase)this.upgrade).getDataHolderStack().getItem()) instanceof UpgradeItem && (upgradeItem = (UpgradeItem)item).requiresEquippedBackpack()) {
                tooltips.add(Component.translatable((String)"screen.travelersbackpack.equip_to_use"));
            }
            guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), tooltips, Optional.empty(), mouseX, mouseY);
        }
        this.renderEnableButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean pButton) {
        if (this.enableButtonMouseClicked(event.x(), event.y())) {
            return true;
        }
        if (this.removeButtonMouseClicked(event.x(), event.y())) {
            return true;
        }
        if (this.isMouseOverIcon(event)) {
            if (((UpgradeBase)this.upgrade).isTabOpened()) {
                ServerboundActionTagPacket.create(0, this.dataHolderSlot, false, 0);
            } else {
                ServerboundActionTagPacket.create(0, this.dataHolderSlot, true, 0);
            }
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if (((BackpackScreen)this.screen).getSlotUnderMouse() != null) {
            return false;
        }
        if (this.isMouseOverEnableButton(pMouseX, pMouseY)) {
            return true;
        }
        return pMouseX > (double)(this.pos.x() + 3) && pMouseY > (double)this.pos.y() && pMouseX < (double)(this.pos.x() + ((UpgradeBase)this.upgrade).getTabSize().x()) && pMouseY < (double)(this.pos.y() + ((UpgradeBase)this.upgrade).getTabSize().y());
    }

    public boolean isMouseOverRemoveButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.removeElement);
    }

    public boolean isMouseOverEnableButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.enableElement);
    }

    public void renderMatchContentsSlotOverlay(GuiGraphics guiGraphics, List<Integer> filter, int settingType, int settingValue, int activeSlots) {
        if (this.isTabOpened() && filter.get(settingType) == settingValue) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (j + i * 3 >= activeSlots) continue;
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 6 + 18 * j, this.pos.y() + 43 + 18 * i, 24.0f, 36.0f, 18, 18, 256, 256);
                }
            }
        }
    }

    public void renderRemoveButton(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.isTabOpened()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.removeElement.pos().x(), this.pos.y() + this.removeElement.pos().y(), 42.0f, 36.0f, this.removeElement.size().x(), this.removeElement.size().y(), 256, 256);
        }
    }

    public boolean removeButtonMouseClicked(double pMouseX, double pMouseY) {
        if (((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverRemoveButton(pMouseX, pMouseY)) {
            if (!this.isBackpackOwner()) {
                return false;
            }
            ServerboundActionTagPacket.create(9, this.dataHolderSlot);
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    public void renderEnableButton(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened()) {
                if (e.isEnabled((UpgradeBase<?>)this.upgrade)) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y(), 18.0f, 24.0f, this.enableElement.size().x(), this.enableElement.size().y(), 256, 256);
                    if (this.isMouseOverEnableButton(mouseX, mouseY)) {
                        guiGraphics.fillGradient(this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y() + 7, this.pos.x() + this.enableElement.pos().x() + 3, this.pos.y() + this.enableElement.pos().y() + 12, -2130706433, -2130706433);
                    }
                } else {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y(), 18.0f, 37.0f, this.enableElement.size().x(), this.enableElement.size().y(), 256, 256);
                    if (this.isMouseOverEnableButton(mouseX, mouseY)) {
                        guiGraphics.fillGradient(this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y() + 1, this.pos.x() + this.enableElement.pos().x() + 3, this.pos.y() + this.enableElement.pos().y() + 6, -2130706433, -2130706433);
                    }
                }
            }
        }
    }

    public void renderEnableButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverEnableButton(mouseX, mouseY)) {
                if (e.isEnabled((UpgradeBase<?>)this.upgrade)) {
                    guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), (Component)Component.literal((String)"Disable Upgrade"), mouseX, mouseY);
                } else {
                    guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), (Component)Component.literal((String)"Enable Upgrade"), mouseX, mouseY);
                }
            }
        }
    }

    public boolean enableButtonMouseClicked(double pMouseX, double pMouseY) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverEnableButton(pMouseX, pMouseY)) {
                if (!this.isBackpackOwner()) {
                    return false;
                }
                ServerboundActionTagPacket.create(0, this.dataHolderSlot, !e.isEnabled((UpgradeBase<?>)this.upgrade), 1);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return false;
    }

    public boolean hasButtons() {
        return this.upgrade instanceof IFilter;
    }

    public boolean isBackpackOwner() {
        return ((BackpackScreen)this.screen).getWrapper().isOwner(((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).player);
    }

    public boolean isTabOpened() {
        return ((UpgradeBase)this.upgrade).isTabOpened();
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.pos.x(), this.pos.y(), this.width + (this.upgrade instanceof IEnable && !this.isTabOpened() ? 4 : 0), this.height};
        return size;
    }
}

