/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.datagen;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.datagen.ModRecipeProvider;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModBlockLootTables
extends BlockLootSubProvider {
    protected ModBlockLootTables(HolderLookup.Provider holderLookupProvidr) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), holderLookupProvidr);
    }

    protected void generate() {
        for (Item item : ModRecipeProvider.BACKPACKS) {
            this.add(Block.byItem((Item)item), this::createBackpackDrop);
        }
        this.add((Block)ModBlocks.BLACK_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.BLUE_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.BROWN_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.CYAN_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.GRAY_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.GREEN_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.LIGHT_BLUE_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.LIGHT_GRAY_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.LIME_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.MAGENTA_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.PURPLE_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.ORANGE_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.PINK_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.RED_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.WHITE_SLEEPING_BAG.get(), this::createSleepingBagDrop);
        this.add((Block)ModBlocks.YELLOW_SLEEPING_BAG.get(), this::createSleepingBagDrop);
    }

    protected LootTable.Builder createBackpackDrop(Block block) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponentsFromBlockEntity((ContextKey)LootContextParams.BLOCK_ENTITY).include((DataComponentType)ModDataComponents.TIER.get()).include((DataComponentType)ModDataComponents.STORAGE_SLOTS.get()).include((DataComponentType)ModDataComponents.UPGRADE_SLOTS.get()).include((DataComponentType)ModDataComponents.TOOL_SLOTS.get()).include((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get()).include((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get()).include((DataComponentType)ModDataComponents.UPGRADES.get()).include((DataComponentType)ModDataComponents.SHOW_TOOL_SLOTS.get()).include((DataComponentType)ModDataComponents.SLEEPING_BAG_COLOR.get()).include((DataComponentType)ModDataComponents.ABILITY_ENABLED.get()).include((DataComponentType)ModDataComponents.COOLDOWN.get()).include((DataComponentType)ModDataComponents.RENDER_INFO.get()).include((DataComponentType)ModDataComponents.STARTER_UPGRADES.get()).include((DataComponentType)ModDataComponents.SLOTS.get()).include((DataComponentType)ModDataComponents.IS_VISIBLE.get()).include((DataComponentType)ModDataComponents.UPGRADE_TICK_INTERVAL.get()).include(DataComponents.CUSTOM_NAME).include(DataComponents.DYED_COLOR)))));
    }

    protected LootTable.Builder createSleepingBagDrop(Block block) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(SleepingBagBlock.PART, (Comparable)BedPart.HEAD))))));
    }

    protected Iterable<Block> getKnownBlocks() {
        List<Item> backpacks = Arrays.asList(ModRecipeProvider.BACKPACKS);
        List<Item> sleepingBags = List.of((Item)ModItems.BLACK_SLEEPING_BAG.get(), (Item)ModItems.BLUE_SLEEPING_BAG.get(), (Item)ModItems.BROWN_SLEEPING_BAG.get(), (Item)ModItems.CYAN_SLEEPING_BAG.get(), (Item)ModItems.GRAY_SLEEPING_BAG.get(), (Item)ModItems.GREEN_SLEEPING_BAG.get(), (Item)ModItems.LIGHT_BLUE_SLEEPING_BAG.get(), (Item)ModItems.LIGHT_GRAY_SLEEPING_BAG.get(), (Item)ModItems.LIME_SLEEPING_BAG.get(), (Item)ModItems.MAGENTA_SLEEPING_BAG.get(), (Item)ModItems.PURPLE_SLEEPING_BAG.get(), (Item)ModItems.ORANGE_SLEEPING_BAG.get(), (Item)ModItems.PINK_SLEEPING_BAG.get(), (Item)ModItems.RED_SLEEPING_BAG.get(), (Item)ModItems.WHITE_SLEEPING_BAG.get(), (Item)ModItems.YELLOW_SLEEPING_BAG.get());
        return Stream.concat(backpacks.stream(), sleepingBags.stream()).map(Block::byItem)::iterator;
    }
}

