/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.transfer.QuadFunction;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class StorageAccessWrapper
implements ResourceHandler<ItemResource> {
    private final BackpackWrapper wrapper;
    private final ResourceHandler<ItemResource> parent;

    public StorageAccessWrapper(BackpackWrapper wrapper, ResourceHandler<ItemResource> parent) {
        this.wrapper = wrapper;
        this.parent = parent;
    }

    public int size() {
        return this.parent.size();
    }

    public ItemResource getResource(int index) {
        return (ItemResource)this.parent.getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.parent.getAmountAsLong(index);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        return this.parent.getCapacityAsLong(index, (Resource)resource);
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.parent.isValid(index, (Resource)resource);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return StorageAccessWrapper.insert(this.wrapper, (arg_0, arg_1, arg_2, arg_3) -> this.parent.insert(arg_0, arg_1, arg_2, arg_3), index, resource, amount, transaction);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return StorageAccessWrapper.extract(this.wrapper, (arg_0, arg_1, arg_2, arg_3) -> this.parent.extract(arg_0, arg_1, arg_2, arg_3), index, resource, amount, transaction);
    }

    public static int matchesStack(ItemStack inserted, Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack) {
        if (((Boolean)((Pair)memorizedStack.getSecond()).getSecond()).booleanValue()) {
            return ItemStackUtils.isSameItemSameTags(inserted, (ItemStack)((Pair)memorizedStack.getSecond()).getFirst()) ? (Integer)memorizedStack.getFirst() : -1;
        }
        return ItemStack.isSameItem((ItemStack)inserted, (ItemStack)((ItemStack)((Pair)memorizedStack.getSecond()).getFirst())) ? (Integer)memorizedStack.getFirst() : -1;
    }

    public static boolean tryVoiding(BackpackWrapper wrapper, ItemStack stack) {
        return wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).map(voidUpgrade -> voidUpgrade.canVoid(stack)).orElse(false);
    }

    public static int insert(BackpackWrapper wrapper, QuadFunction<Integer, ItemResource, Integer, TransactionContext, Integer> inserter, int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (StorageAccessWrapper.tryVoiding(wrapper, resource.toStack())) {
            return amount;
        }
        if (!wrapper.getMemorySlots().isEmpty()) {
            ItemStack stack = resource.toStack();
            for (Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack : wrapper.getMemorySlots()) {
                int result;
                if (((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()).getItem() != stack.getItem() || (result = StorageAccessWrapper.matchesStack(stack, memorizedStack)) == -1) continue;
                return inserter.apply(result, resource, amount, transaction);
            }
        }
        return wrapper.getUnsortableSlots().contains(index) ? 0 : inserter.apply(index, resource, amount, transaction);
    }

    public static int extract(BackpackWrapper wrapper, QuadFunction<Integer, ItemResource, Integer, TransactionContext, Integer> extractor, int index, ItemResource resource, int amount, TransactionContext transaction) {
        return wrapper.getUnsortableSlots().contains(index) ? 0 : extractor.apply(index, resource, amount, transaction);
    }
}

