/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;

public class BackpackSlotItemHandler
extends ResourceHandlerSlot {
    public static final List<Item> BLACKLISTED_ITEMS = new ArrayList<Item>();
    private final int containerIndex;

    public BackpackSlotItemHandler(ItemStacksResourceHandler handler, int index, int xPosition, int yPosition) {
        super((ResourceHandler)handler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)handler).set(arg_0, arg_1, arg_2), index, xPosition, yPosition);
        this.containerIndex = index;
    }

    public static boolean isItemValid(ItemStack stack) {
        if (BLACKLISTED_ITEMS.contains(stack.getItem())) {
            return false;
        }
        return !(stack.getItem() instanceof TravelersBackpackItem) && !stack.is(ModTags.BLACKLISTED_ITEMS) && ((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowShulkerBoxes.get() != false || stack.getItem().canFitInsideContainerItems());
    }

    public int getContainerSlot() {
        return this.containerIndex;
    }

    public boolean mayPickup(Player playerIn) {
        return true;
    }
}

