/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import net.neoforged.neoforge.transfer.resource.Resource;

public class UpgradeLockableSlotItemHandler
extends ResourceHandlerSlot {
    public BackpackBaseMenu menu;
    public boolean isLocked = false;
    public boolean isHidden = false;
    public final int containerIndex;

    public UpgradeLockableSlotItemHandler(BackpackBaseMenu menu, BackpackResourceHandler handler, int index, int xPosition, int yPosition) {
        super((ResourceHandler)handler, (arg_0, arg_1, arg_2) -> ((BackpackResourceHandler)handler).set(arg_0, arg_1, arg_2), index, xPosition, yPosition);
        this.menu = menu;
        this.containerIndex = index;
        if (handler.getStackInSlot(index).getItem() instanceof UpgradeItem && menu.getWrapper().getUpgradeManager().hasUpgradeInSlot(index)) {
            this.setLocked(true);
        }
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean mayPlace(ItemStack stack) {
        if (stack.getItem() instanceof TanksUpgradeItem && !this.getResourceHandler().isValid(this.getSlotIndex(), (Resource)ItemResource.of((ItemStack)stack)) && !TanksUpgradeItem.canBePutInBackpack(this.menu.getWrapper().getBackpackTankCapacity(), stack)) {
            BackpackScreen.displayTanksUpgradeWarning(this.menu.player);
        }
        return super.mayPlace(stack);
    }

    public boolean mayPickup(Player playerIn) {
        return super.mayPickup(playerIn) && !this.isLocked && !this.isHidden;
    }

    public boolean isActive() {
        return super.isActive() && !this.isLocked && !this.isHidden;
    }

    public void setByPlayer(ItemStack pNewStack, ItemStack pOldStack) {
        if (this.menu.player.level().isClientSide()) {
            this.menu.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
        }
        super.setByPlayer(pNewStack, pOldStack);
    }
}

