/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.transfer;

import com.google.common.base.Preconditions;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ItemAccessResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class BackpackItemAccess
extends ItemAccessResourceHandler<ItemResource> {
    protected final Item validItem;
    protected final DataComponentType<BackpackContainerContents> component;
    protected final BackpackWrapper wrapper;

    public BackpackItemAccess(ItemAccess itemAccess, BackpackWrapper wrapper, DataComponentType<BackpackContainerContents> component) {
        super(itemAccess, wrapper.getStorageSize());
        this.wrapper = wrapper;
        this.validItem = itemAccess.getResource().getItem();
        this.component = component;
        Preconditions.checkArgument((wrapper.getStorageSize() <= 256 ? 1 : 0) != 0, (Object)"The max size of ItemContainerContents is 256 slots.");
    }

    protected BackpackContainerContents getContents(ItemResource accessResource) {
        return (BackpackContainerContents)accessResource.getOrDefault(this.component, (Object)BackpackContainerContents.EMPTY);
    }

    protected ItemStack getStackFromContents(BackpackContainerContents contents, int slot) {
        return slot < contents.getItems().size() ? contents.getStackInSlot(slot) : ItemStack.EMPTY;
    }

    protected ItemResource getResourceFrom(ItemResource accessResource, int index) {
        if (accessResource.is((Object)this.validItem)) {
            return ItemResource.of((ItemStack)this.getStackFromContents(this.getContents(accessResource), index));
        }
        return ItemResource.EMPTY;
    }

    protected int getAmountFrom(ItemResource accessResource, int index) {
        if (accessResource.is((Object)this.validItem)) {
            return this.getStackFromContents(this.getContents(accessResource), index).getCount();
        }
        return 0;
    }

    protected ItemResource update(ItemResource accessResource, int index, ItemResource newResource, int newAmount) {
        BackpackContainerContents contents = this.getContents(accessResource);
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getItems().size(), this.size), (Object)ItemStack.EMPTY);
        contents.copyInto((NonNullList<ItemStack>)list);
        list.set(index, (Object)newResource.toStack(newAmount));
        return accessResource.with(this.component, (Object)BackpackContainerContents.fromItems(list.size(), (List<ItemStack>)list));
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.itemAccess.getResource().is((Object)this.validItem);
    }

    protected int getCapacity(int index, ItemResource resource) {
        return resource.isEmpty() ? 99 : Math.min(resource.getMaxStackSize(), 99);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return StorageAccessWrapper.insert(this.wrapper, (x$0, x$1, x$2, x$3) -> super.insert(x$0, x$1, x$2, x$3), index, resource, amount, transaction);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return StorageAccessWrapper.extract(this.wrapper, (x$0, x$1, x$2, x$3) -> super.extract(x$0, x$1, x$2, x$3), index, resource, amount, transaction);
    }
}

