/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.transfer;

import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ItemFluidTankWrapper
implements ResourceHandler<FluidResource> {
    private final ItemStack backpack;
    private final TanksUpgrade upgrade;

    public ItemFluidTankWrapper(ItemStack backpack, TanksUpgrade upgrade) {
        this.backpack = backpack;
        this.upgrade = upgrade;
    }

    public int size() {
        return 2;
    }

    public FluidResource getResource(int index) {
        if (index == 0) {
            return FluidResource.of((FluidStack)this.upgrade.getLeftTank().getFluid());
        }
        return FluidResource.of((FluidStack)this.upgrade.getRightTank().getFluid());
    }

    public long getAmountAsLong(int index) {
        if (index == 0) {
            return this.upgrade.getLeftTank().getFluidAmount();
        }
        return this.upgrade.getRightTank().getFluidAmount();
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        if (index == 0) {
            return this.upgrade.getLeftTank().getCapacity();
        }
        return this.upgrade.getRightTank().getCapacity();
    }

    public boolean isValid(int index, FluidResource resource) {
        if (index == 0) {
            return this.upgrade.getLeftTank().isFluidValid(index, resource.toStack(this.getAmountAsInt(index)));
        }
        return this.upgrade.getRightTank().isFluidValid(index, resource.toStack(this.getAmountAsInt(index)));
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.backpack.getCount() > 1) {
            return 0;
        }
        if (this.upgrade.getLeftTank().fill(resource.toStack(amount), IFluidHandler.FluidAction.SIMULATE) > 0) {
            return this.upgrade.getLeftTank().fill(resource.toStack(amount), IFluidHandler.FluidAction.EXECUTE);
        }
        return this.upgrade.getRightTank().fill(resource.toStack(amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.backpack.getCount() > 1) {
            return 0;
        }
        if (!this.upgrade.getLeftTank().drain(amount, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return this.upgrade.getLeftTank().drain(amount, IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
        return this.upgrade.getRightTank().drain(amount, IFluidHandler.FluidAction.EXECUTE).getAmount();
    }
}

