/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import org.jetbrains.annotations.Nullable;

public class FeedingFilterSettings
extends FilterSettingsBase {
    public static final int ALLOW_MODE = 0;
    public static final int HUNGER_MODE = 1;
    public static final int IGNORE_EFFECT_MODE = 2;
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;
    public static final int ALWAYS_EAT = 0;
    public static final int HALF_NUTRITION = 1;
    public static final int FULL_NUTRITION = 2;
    public static final int BLOCK_BAD_EFFECTS = 0;
    public static final int ALLOW_BAD_EFFECTS = 1;

    public FeedingFilterSettings(BackpackResourceHandler storage, List<ItemStack> items, List<Integer> filterSettings, HolderLookup.Provider access) {
        super(storage, items, filterSettings, access, (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get());
    }

    @Override
    public boolean matchesFilter(@Nullable Player player, ItemStack stack) {
        FoodData foodData = player.getFoodData();
        if ((Integer)this.filterSettings.get(0) == 0) {
            return this.filterItems.stream().anyMatch(food -> ItemStack.isSameItemSameComponents((ItemStack)food.copyWithCount(1), (ItemStack)stack)) && this.compareHungerLevel(foodData, stack) && this.checkHarmfulEffects(stack);
        }
        if ((Integer)this.filterSettings.get(0) == 1) {
            return this.filterItems.stream().noneMatch(food -> ItemStack.isSameItemSameComponents((ItemStack)food.copyWithCount(1), (ItemStack)stack)) && this.compareHungerLevel(foodData, stack) && this.checkHarmfulEffects(stack);
        }
        return false;
    }

    public boolean compareHungerLevel(FoodData foodData, ItemStack stack) {
        if ((Integer)this.filterSettings.get(1) == 0) {
            return foodData.needsFood();
        }
        if ((Integer)this.filterSettings.get(1) == 1) {
            return this.getNutritionDifference(foodData, stack) <= this.getHalfOfStackHunger(stack);
        }
        if ((Integer)this.filterSettings.get(1) == 2) {
            return this.getNutritionDifference(foodData, stack) <= 0;
        }
        return false;
    }

    public boolean checkHarmfulEffects(ItemStack stack) {
        if ((Integer)this.filterSettings.get(2) == 0) {
            return this.checkHarmfulEffect((Consumable)stack.get(DataComponents.CONSUMABLE));
        }
        return true;
    }

    public boolean checkHarmfulEffect(Consumable consumable) {
        if (consumable != null) {
            for (ConsumeEffect effect : consumable.onConsumeEffects()) {
                if (effect.getType() != ConsumeEffect.Type.APPLY_EFFECTS) continue;
                ApplyStatusEffectsConsumeEffect applyStatusEffect = (ApplyStatusEffectsConsumeEffect)effect;
                for (MobEffectInstance mobEffect : applyStatusEffect.effects()) {
                    if (((MobEffect)mobEffect.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int getNutritionDifference(FoodData foodData, ItemStack stack) {
        if (foodData.needsFood()) {
            FoodProperties foodProps = (FoodProperties)stack.get(DataComponents.FOOD);
            int foodNutrition = foodProps.nutrition();
            int playerNutrition = foodData.getFoodLevel();
            return playerNutrition + foodNutrition - 20;
        }
        return 0;
    }

    public int getHalfOfStackHunger(ItemStack stack) {
        return ((FoodProperties)stack.get(DataComponents.FOOD)).nutrition() / 2;
    }
}

