/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetFilterSettings;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class MagnetUpgrade
extends FilterUpgradeBase<MagnetUpgrade, MagnetFilterSettings>
implements IEnable,
ITickableUpgrade {
    public MagnetUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get(), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.slotsInRow.get(), filter, filterTags);
    }

    @Override
    public MagnetFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new MagnetFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.isEmpty()).toList(), this.getFilter(), filterTags, (HolderLookup.Provider)manager.getWrapper().getRegistryAccess());
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.tickRate.get();
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.teleportNearbyItems(player, level);
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void teleportNearbyItems(Player player, Level level) {
        if (level.isClientSide()) {
            return;
        }
        int radius = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.pullRange.get();
        AABB area = new AABB(player.position().add((double)(-radius), (double)(-radius), (double)(-radius)), player.position().add((double)radius, (double)radius, (double)radius));
        List items = level.getEntities((EntityTypeTest)EntityType.ITEM, area, item -> !(!item.isAlive() || level.isClientSide() && item.tickCount <= 1 || item.getOwner() != null && item.getOwner().equals((Object)player) && item.tickCount <= 80 || item.getItem().isEmpty() || item.getPersistentData().contains("PreventRemoteMovement") || !((MagnetFilterSettings)this.getFilterSettings()).matchesFilter(player, item.getItem())));
        items.forEach(item -> {
            item.setPos(player.getX(), player.getY(), player.getZ());
            item.setNoPickUpDelay();
        });
    }

    @Override
    protected FilterHandler createFilter(NonNullList<ItemStack> stacks, final int size) {
        return new FilterHandler(stacks, size){

            protected void onContentsChanged(int slot, ItemStack previousStack) {
                MagnetUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(size, MagnetUpgrade.this.filter));
                ((MagnetFilterSettings)MagnetUpgrade.this.getFilterSettings()).updateFilter((List<ItemStack>)((BackpackContainerContents)MagnetUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
                ((MagnetFilterSettings)MagnetUpgrade.this.getFilterSettings()).updateFilterTags((List)MagnetUpgrade.this.getDataHolderStack().get(ModDataComponents.FILTER_TAGS));
                MagnetUpgrade.this.changeListeners.forEach(Runnable::run);
            }
        };
    }
}

