/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.Optional;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;

public class JukeboxUpgradeItem
extends UpgradeItem {
    public JukeboxUpgradeItem(Item.Properties pProperties) {
        super(pProperties, "jukebox_upgrade");
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        if (TravelersBackpackConfig.serverSpec.isLoaded()) {
            return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.enableJukeboxUpgrade.get() != false && super.isEnabled(enabledFeatures);
        }
        return super.isEnabled(enabledFeatures);
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return JukeboxUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents musicDisk = (BackpackContainerContents)provider.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(1));
            return Optional.of(new JukeboxUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, musicDisk.getItems()));
        };
    }
}

