/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.apache.commons.lang3.function.TriFunction;

public class MagnetUpgradeItem
extends UpgradeItem {
    public MagnetUpgradeItem(Item.Properties pProperties) {
        super(pProperties, null);
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        if (TravelersBackpackConfig.serverSpec.isLoaded()) {
            return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.enableMagnetUpgrade.get() != false && super.isEnabled(enabledFeatures);
        }
        return super.isEnabled(enabledFeatures);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        tooltipConsumer.accept((Component)Component.translatable((String)"item.travelersbackpack.magnet_upgrade_tooltip", (Object[])new Object[]{TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.pullRange.get()}).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipConsumer, tooltipFlag);
    }

    @Override
    public boolean isTickingUpgrade() {
        return true;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return MagnetUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = (BackpackContainerContents)provider.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(9));
            ArrayList<String> filterTags = new ArrayList<String>((Collection)provider.getOrDefault(ModDataComponents.FILTER_TAGS, new ArrayList()));
            return Optional.of(new MagnetUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, filter.getItems(), (List<String>)filterTags));
        };
    }
}

