/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundSendMessagePacket(boolean drop, BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"send_message");
    public static final CustomPacketPayload.Type<ClientboundSendMessagePacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSendMessagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ClientboundSendMessagePacket::drop, (StreamCodec)BlockPos.STREAM_CODEC, ClientboundSendMessagePacket::pos, ClientboundSendMessagePacket::new);

    public static void handle(ClientboundSendMessagePacket message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> {
                if (((Boolean)TravelersBackpackConfig.CLIENT.sendBackpackCoordinatesMessage.get()).booleanValue() && Minecraft.getInstance().player != null) {
                    Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)(message.drop ? "information.travelersbackpack.backpack_drop" : "information.travelersbackpack.backpack_coords"), (Object[])new Object[]{message.pos().getX(), message.pos().getY(), message.pos().getZ()}));
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

