/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class InventoryHelper {
    public static ItemStack removeItem(BackpackResourceHandler handler, int slot, int amount) {
        if (slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).isEmpty() && amount > 0) {
            ItemStack currentStack = handler.getStackInSlot(slot).copy();
            ItemStack stackAtPointer = currentStack.copy();
            currentStack.split(amount);
            handler.setStackInSlot(slot, currentStack);
            return stackAtPointer;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack removeItemShiftClick(BackpackResourceHandler handler, int slot, int amount) {
        if (slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).isEmpty() && amount > 0) {
            ItemStack currentStack = handler.getStackInSlot(slot);
            currentStack.split(amount);
            handler.setStackInSlot(slot, currentStack);
            return handler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack takeItem(BackpackResourceHandler handler, int slot) {
        return slot >= 0 && slot < handler.getSlots() ? ItemUtil.insertItemReturnRemaining((ResourceHandler)handler, (int)slot, (ItemStack)ItemStack.EMPTY, (boolean)false, null) : ItemStack.EMPTY;
    }

    public static boolean isEmpty(BackpackResourceHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static BackpackContainerContents itemsToList(int size, BackpackResourceHandler handler) {
        int i;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(size);
        for (i = 0; i < handler.getSlots(); ++i) {
            list.add(handler.getStackInSlot(i));
        }
        for (i = handler.getSlots(); i < size; ++i) {
            list.add(ItemStack.EMPTY);
        }
        return BackpackContainerContents.fromItems(size, list);
    }

    public static void iterateHandler(ResourceHandler<ItemResource> handler, BiConsumer<Integer, ItemStack> consumer) {
        for (int i = 0; i < handler.size(); ++i) {
            ItemStack stack = ((ItemResource)handler.getResource(i)).toStack(handler.getAmountAsInt(i));
            consumer.accept(i, stack);
        }
    }

    public static void iterateHandler(IItemHandler handler, BiConsumer<Integer, ItemStack> consumer) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            consumer.accept(i, stack);
        }
    }

    public static boolean iterate(BackpackResourceHandler handler, BiFunction<Integer, ItemStack, Boolean> function) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean matches = function.apply(i, handler.getStackInSlot(i).copy());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static ItemStack addItemStackToHandler(IItemHandlerModifiable handler, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack extractFromBackpack(BackpackResourceHandler handler, ItemStack stack, int amount, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)handler.getStackInSlot(i))) continue;
            return InventoryHelper.extractItem((ResourceHandler<ItemResource>)handler, i, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack extractItem(ResourceHandler<ItemResource> handler, int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        ItemResource resource = (ItemResource)handler.getResource(slot);
        if (resource.isEmpty()) {
            return ItemStack.EMPTY;
        }
        amount = Math.min(amount, resource.getMaxStackSize());
        try (Transaction tx = Transaction.openRoot();){
            int extracted = handler.extract(slot, (Resource)resource, amount, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = resource.toStack(extracted);
            return itemStack;
        }
    }
}

