/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.function.Consumer;
import net.minecraft.class_1799;

public abstract class UpgradeBase<T>
implements IUpgrade<T> {
    public UpgradeManager upgradeManager;
    public int dataHolderSlot;
    public Point openTabSize;

    public UpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize) {
        this.upgradeManager = manager;
        this.dataHolderSlot = dataHolderSlot;
        this.openTabSize = openTabSize;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public int getDataHolderSlot() {
        return this.dataHolderSlot;
    }

    @Override
    public boolean isTabOpened() {
        return NbtHelper.getOrDefault(this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "TabOpen", false);
    }

    public class_1799 getDataHolderStack() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot);
    }

    @Override
    public Point getTabSize() {
        if (this.isTabOpened()) {
            UpgradeBase upgradeBase = this;
            if (upgradeBase instanceof IFilterSlots) {
                IFilterSlots slots = (IFilterSlots)((Object)upgradeBase);
                int x = this.openTabSize.x();
                if (slots.getSlotsInRow() > 3) {
                    x += (slots.getSlotsInRow() - 3) * 18;
                }
                return new Point(x, this.openTabSize.y() + 18 * slots.getRows());
            }
            return this.openTabSize;
        }
        return new Point(24, 24);
    }

    public void updateDataHolderUnchecked(Consumer<class_1799> updater) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        if (dataHolderStack.method_7960()) {
            return;
        }
        updater.accept(dataHolderStack);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public void updateDataHolderUnchecked(String dataKey, Object value) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        if (dataHolderStack.method_7960()) {
            return;
        }
        NbtHelper.set(dataHolderStack, dataKey, value);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public void setCooldown(int cooldown) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        NbtHelper.set(dataHolderStack, "Cooldown", cooldown);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public int getCooldown() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "Cooldown", 100);
    }

    public boolean hasCooldown() {
        return NbtHelper.has(this.getDataHolderStack(), "Cooldown");
    }
}

