/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class NbtHelper {
    public static boolean isInteger(String key) {
        return key.equals("StorageSlots") || key.equals("UpgradeSlots") || key.equals("ToolSlots") || key.equals("Tier") || key.equals("Cooldown") || key.equals("SortType") || key.equals("SleepingBagColor") || key.equals("UpgradeTickInterval") || key.equals("Color") || key.equals("CookingTotalTime") || key.equals("BurnTotalTime");
    }

    public static boolean isBoolean(String key) {
        return key.equals("TabOpen") || key.equals("UpgradeEnabled") || key.equals("ShiftClickToBackpack") || key.equals("ShowToolSlots") || key.equals("ShowMoreButtons") || key.equals("IsPlaying") || key.equals("AbilityEnabled") || key.equals("IsVisible");
    }

    public static boolean isLong(String key) {
        return key.equals("BurnFinishTime") || key.equals("CookingFinishTime");
    }

    public static void set(class_1799 stack, String key, Object value) {
        if (NbtHelper.isInteger(key)) {
            stack.method_7948().method_10569(key, ((Integer)value).intValue());
            return;
        }
        if (NbtHelper.isBoolean(key)) {
            stack.method_7948().method_10556(key, ((Boolean)value).booleanValue());
            return;
        }
        if (NbtHelper.isLong(key)) {
            stack.method_7948().method_10544(key, ((Long)value).longValue());
            return;
        }
        switch (key) {
            case "Inventory": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeHandler((ItemStackHandler)value));
                break;
            }
            case "Upgrades": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeHandler((ItemStackHandler)value));
                break;
            }
            case "ToolsInventory": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeHandler((ItemStackHandler)value));
                break;
            }
            case "StarterUpgrades": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeStarterUpgrades((List)value));
                break;
            }
            case "RenderInfo": {
                stack.method_7948().method_10566(key, (class_2520)((RenderInfo)value).compoundTag());
                break;
            }
            case "Fluids": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeFluids((Fluids)value));
                break;
            }
            case "FilterSettings": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeIntList((List)value, key));
                break;
            }
            case "FilterTags": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeStringList((List)value, key));
                break;
            }
            case "UnsortableSlots": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeIntList((List)value, key));
                break;
            }
            case "MemorySlots": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeMemorySlots((List)value));
                break;
            }
            case "HoseModes": {
                stack.method_7948().method_10566(key, (class_2520)NbtHelper.serializeIntList((List)value, key));
                break;
            }
            default: {
                stack.method_7948().method_10566(key, (class_2520)((class_2487)value));
            }
        }
    }

    public static <T> T getOrDefault(class_1799 stack, String key, T defaultValue) {
        if (stack.method_7985() && stack.method_7969().method_10545(key)) {
            if (NbtHelper.isInteger(key)) {
                return (T)Integer.valueOf(stack.method_7969().method_10550(key));
            }
            if (NbtHelper.isBoolean(key)) {
                return (T)Boolean.valueOf(stack.method_7969().method_10577(key));
            }
            if (NbtHelper.isLong(key)) {
                return (T)Long.valueOf(stack.method_7969().method_10537(key));
            }
            if (stack.method_7969().method_10545(key)) {
                switch (key) {
                    case "Inventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "Upgrades": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "ToolsInventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "StarterUpgrades": {
                        return (T)NbtHelper.deserializeStarterUpgrades(stack.method_7969().method_10562(key));
                    }
                    case "RenderInfo": {
                        return (T)new RenderInfo(stack.method_7969().method_10562(key));
                    }
                    case "Fluids": {
                        return (T)new Fluids(NbtHelper.deserializeLeftFluidStack(stack.method_7969().method_10562(key)), NbtHelper.deserializeRightFluidStack(stack.method_7969().method_10562(key)));
                    }
                    case "FilterSettings": {
                        return (T)NbtHelper.deserializeIntList(stack.method_7969(), key);
                    }
                    case "FilterTags": {
                        return (T)NbtHelper.deserializeStringList(stack.method_7969(), key);
                    }
                    case "UnsortableSlots": {
                        return (T)NbtHelper.deserializeIntList(stack.method_7969(), key);
                    }
                    case "MemorySlots": {
                        return (T)NbtHelper.deserializeMemorySlots(stack.method_7969());
                    }
                    case "HoseModes": {
                        return (T)NbtHelper.deserializeIntList(stack.method_7969(), key);
                    }
                }
                return (T)stack.method_7969().method_10562(key);
            }
        }
        return defaultValue;
    }

    @Nullable
    public static <T> T get(class_1799 stack, String key) {
        if (stack.method_7985() && stack.method_7969().method_10545(key)) {
            if (NbtHelper.isInteger(key)) {
                return (T)Integer.valueOf(stack.method_7969().method_10550(key));
            }
            if (NbtHelper.isBoolean(key)) {
                return (T)Boolean.valueOf(stack.method_7969().method_10577(key));
            }
            if (NbtHelper.isLong(key)) {
                return (T)Long.valueOf(stack.method_7969().method_10537(key));
            }
            if (stack.method_7969().method_10545(key)) {
                switch (key) {
                    case "Inventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "Upgrades": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "ToolsInventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "StarterUpgrades": {
                        return (T)NbtHelper.deserializeStarterUpgrades(stack.method_7969().method_10562(key));
                    }
                    case "RenderInfo": {
                        return (T)new RenderInfo(stack.method_7969().method_10562(key));
                    }
                    case "Fluids": {
                        return (T)new Fluids(NbtHelper.deserializeLeftFluidStack(stack.method_7969().method_10562(key)), NbtHelper.deserializeRightFluidStack(stack.method_7969().method_10562(key)));
                    }
                    case "FilterSettings": {
                        return (T)NbtHelper.deserializeIntList(stack.method_7969(), key);
                    }
                    case "FilterTags": {
                        return (T)NbtHelper.deserializeStringList(stack.method_7969(), key);
                    }
                    case "UnsortableSlots": {
                        return (T)NbtHelper.deserializeIntList(stack.method_7969(), key);
                    }
                    case "MemorySlots": {
                        return (T)NbtHelper.deserializeMemorySlots(stack.method_7969());
                    }
                    case "HoseModes": {
                        return (T)NbtHelper.deserializeIntList(stack.method_7969(), key);
                    }
                }
                return (T)stack.method_7969().method_10562(key);
            }
        }
        return null;
    }

    public static boolean has(class_1799 stack, String key) {
        if (stack.method_7985()) {
            return stack.method_7969().method_10545(key);
        }
        return false;
    }

    public static void remove(class_1799 stack, String key) {
        if (stack.method_7985()) {
            stack.method_7969().method_10551(key);
        }
    }

    public static class_2487 serializeHandler(ItemStackHandler handler) {
        return NbtHelper.serializeNBT(handler);
    }

    public static class_2487 serializeNBT(ItemStackHandler handler) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < handler.getSlots(); ++i) {
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            handler.getStackInSlot(i).method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", nbtTagList.size());
        return nbt;
    }

    public static class_2487 serializeStarterUpgrades(List<class_1799> upgrades) {
        return NbtHelper.serializeList(upgrades);
    }

    public static List<class_1799> deserializeStarterUpgrades(class_2487 tag) {
        return NbtHelper.deserializeList(tag);
    }

    public static class_2487 getHandlerNbt(class_1799 stack, String key) {
        return stack.method_7969().method_10562(key);
    }

    public static class_2487 expandTag(class_1799 stack, String key, int defaultSize) {
        class_2487 tag = NbtHelper.getHandlerNbt(stack, key);
        class_2371 stacks = class_2371.method_10213((int)defaultSize, (Object)class_1799.field_8037);
        class_2499 tagList = tag.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
        }
        return NbtHelper.serializeHandler(new ItemStackHandler((class_2371<class_1799>)stacks));
    }

    public static class_2371<class_1799> deserializeHandler(class_1799 stack, String key) {
        class_2499 tagList = stack.method_7969().method_10562(key).method_10554("Items", 10);
        int size = stack.method_7969().method_10545("Size") ? stack.method_7969().method_10562(key).method_10550("Size") : tagList.size();
        class_2371 stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
        }
        return stacks;
    }

    public static void update(class_1799 backpack, String key, int defaultSize, int slot, class_1799 stack) {
        if (backpack.method_7985() && backpack.method_7969().method_10545(key)) {
            class_2487 unboxed = backpack.method_7969().method_10562(key);
            class_2499 itemsListed = unboxed.method_10554("Items", 10);
            class_2487 newItemTag = new class_2487();
            newItemTag.method_10569("Slot", slot);
            stack.method_7953(newItemTag);
            if (slot >= 0 && slot < itemsListed.size()) {
                itemsListed.method_10606(slot, (class_2520)newItemTag);
            }
        } else {
            class_2499 nbtTagList = new class_2499();
            for (int i = 0; i < defaultSize; ++i) {
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                class_1799.field_8037.method_7972().method_7953(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            class_2487 newItemTag = new class_2487();
            newItemTag.method_10569("Slot", slot);
            stack.method_7953(newItemTag);
            if (slot >= 0 && slot < nbtTagList.size()) {
                nbtTagList.method_10606(slot, (class_2520)newItemTag);
            }
            class_2487 nbt = new class_2487();
            nbt.method_10566("Items", (class_2520)nbtTagList);
            nbt.method_10569("Size", nbtTagList.size());
            backpack.method_7948().method_10566(key, (class_2520)nbt);
        }
    }

    public static FluidVariantWrapper deserializeLeftFluidStack(class_2487 tag) {
        return FluidVariantWrapper.parseOptional(tag.method_10562("leftFluidStack"));
    }

    public static FluidVariantWrapper deserializeRightFluidStack(class_2487 tag) {
        return FluidVariantWrapper.parseOptional(tag.method_10562("rightFluidStack"));
    }

    public static class_2487 serializeFluids(Fluids fluids) {
        class_2487 tag = new class_2487();
        tag.method_10566("leftFluidStack", fluids.leftFluidStack().saveOptional());
        tag.method_10566("rightFluidStack", fluids.rightFluidStack().saveOptional());
        return tag;
    }

    public static class_2487 serializeList(List<class_1799> stacks) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            stacks.get(i).method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        return nbt;
    }

    public static List<class_1799> deserializeList(class_2487 tag) {
        class_2499 tagList = tag.method_10554("Items", 10);
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (int i = 0; i < tagList.size(); ++i) {
            stacks.add(class_1799.method_7915((class_2487)tagList.method_10602(i)));
        }
        return stacks;
    }

    public static class_2499 serializeIntList(List<Integer> ints, String key) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < ints.size(); ++i) {
            nbtTagList.method_10531(i, (class_2520)class_2497.method_23247((int)ints.get(i)));
        }
        return nbtTagList;
    }

    public static List<Integer> deserializeIntList(class_2487 tag, String key) {
        class_2499 tagList = tag.method_10554(key, 3);
        ArrayList<Integer> filter = new ArrayList<Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            filter.add(tagList.method_10600(i));
        }
        if (filter.isEmpty()) {
            int[] array;
            for (int i : array = tag.method_10561(key)) {
                filter.add(i);
            }
        }
        return filter;
    }

    public static class_2499 serializeStringList(List<String> strings, String key) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < strings.size(); ++i) {
            nbtTagList.method_10531(i, (class_2520)class_2519.method_23256((String)strings.get(i)));
        }
        return nbtTagList;
    }

    public static List<String> deserializeStringList(class_2487 tag, String key) {
        class_2499 tagList = tag.method_10554(key, 8);
        ArrayList<String> filter = new ArrayList<String>();
        for (int i = 0; i < tagList.size(); ++i) {
            filter.add(tagList.method_10608(i));
        }
        return filter;
    }

    public static class_2499 serializeMemorySlots(List<Pair<Integer, Pair<class_1799, Boolean>>> memorySlots) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < memorySlots.size(); ++i) {
            class_2487 pairTag = new class_2487();
            pairTag.method_10569("Slot", ((Integer)memorySlots.get(i).getFirst()).intValue());
            pairTag.method_10566("Pair", (class_2520)NbtHelper.serializeMemoryStack((Pair<class_1799, Boolean>)((Pair)memorySlots.get(i).getSecond())));
            nbtTagList.add((Object)pairTag);
        }
        return nbtTagList;
    }

    public static class_2487 serializeMemoryStack(Pair<class_1799, Boolean> memoryStack) {
        class_2487 pair = new class_2487();
        ((class_1799)memoryStack.getFirst()).method_7953(pair);
        pair.method_10556("matchNbt", ((Boolean)memoryStack.getSecond()).booleanValue());
        return pair;
    }

    public static List<Pair<Integer, Pair<class_1799, Boolean>>> deserializeMemorySlots(class_2487 tag) {
        class_2499 tagList = tag.method_10554("MemorySlots", 10);
        ArrayList<Pair<Integer, Pair<class_1799, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 pairTag = tagList.method_10602(i);
            int index = pairTag.method_10550("Slot");
            Pair<class_1799, Boolean> pair = NbtHelper.deserializeMemoryStack(pairTag.method_10562("Pair"));
            memorySlots.add((Pair<Integer, Pair<class_1799, Boolean>>)Pair.of((Object)index, pair));
        }
        return memorySlots;
    }

    public static Pair<class_1799, Boolean> deserializeMemoryStack(class_2487 tag) {
        return Pair.of((Object)class_1799.method_7915((class_2487)tag), (Object)tag.method_10577("matchNbt"));
    }

    public static class_2487 serializeMemorySlotsPacket(List<Pair<Integer, Boolean>> memorySlots) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < memorySlots.size(); ++i) {
            class_2487 pairTag = new class_2487();
            pairTag.method_10569("Slot", ((Integer)memorySlots.get(i).getFirst()).intValue());
            pairTag.method_10556("matchNbt", ((Boolean)memorySlots.get(i).getSecond()).booleanValue());
            nbtTagList.add((Object)pairTag);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("MemorySlots", (class_2520)nbtTagList);
        return tag;
    }

    public static List<Pair<Integer, Boolean>> deserializeMemorySlotsPacket(class_2487 tag) {
        class_2499 tagList = tag.method_10554("MemorySlots", 10);
        ArrayList<Pair<Integer, Boolean>> memorySlots = new ArrayList<Pair<Integer, Boolean>>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 pairTag = tagList.method_10602(i);
            int index = pairTag.method_10550("Slot");
            boolean matchNbt = pairTag.method_10577("matchNbt");
            memorySlots.add((Pair<Integer, Boolean>)Pair.of((Object)index, (Object)matchNbt));
        }
        return memorySlots;
    }
}

