package com.tiviacz.travelersbackpack.advancements;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class ActionTypeTrigger extends class_4558<ActionTypeTrigger.TriggerInstance> {
    public void trigger(class_3222 player, String type) {
        this.method_22510(player, instance -> instance.test(type));
    }

    @Override
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(Optional<class_5258> player, String action) implements SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                        class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::player),
                        Codec.STRING.fieldOf("action").forGetter(TriggerInstance::action))
                .apply(instance, TriggerInstance::new));

        public boolean test(String type) {
            return this.action.equals(type);
        }

        @Override
        public Optional<class_5258> player() {
            return this.player;
        }
    }

    public static final String UNDYE_BACKPACK = "undye_backpack";
    public static final String CHANGE_SLEEPING_BAG = "change_sleeping_bag";
    public static final String USE_SLEEPING_BAG = "use_sleeping_bag";
    public static final String REVERT_CUSTOM_BACKPACK = "revert_custom_backpack";
    public static final String SWAP_TOOLS = "swap_tools";
    public static final String HOSE_SUCK = "hose_suck";
    public static final String HOSE_SPILL = "hose_spill";
    public static final String HOSE_DRINK = "hose_drink";
    public static final String HOSE_SPILL_POTION = "hose_spill_potion";
    public static final String HOSE_DRINK_POTION = "hose_drink_potion";
}