package com.tiviacz.travelersbackpack.api.fluids;

import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public abstract class EffectFluid {
    public final String uniqueId;
    public final class_3611 fluid;
    public int effectID;
    public final long amountRequired;

    public EffectFluid(String uniqueId, FluidVariantWrapper fluidVariantWrapper, long amountRequired) {
        this(uniqueId, fluidVariantWrapper.fluidVariant().getFluid(), amountRequired);
    }

    public EffectFluid(String uniqueId, class_3611 fluid, long amountRequired) {
        this.uniqueId = uniqueId;
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;

        if(fluid != null) {
            com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public EffectFluid(String uniqueId, String modid, String fluidName, long amountRequired) {
        class_3611 fluid = class_7923.field_41173.method_10223(class_2960.method_60655(modid, fluidName));
        this.uniqueId = uniqueId;
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;

        if(fluid != null) {
            com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setEffectID(int id) {
        effectID = id;
    }

    public int getEffectID() {
        return effectID;
    }

    /**
     * This method determines what will happen to the player (or world!) when drinking the
     * corresponding fluid. For example set potion effects, set player on fire,
     * heal, fill hunger, etc. You can use the world parameter to make
     * conditions based on where the player is.
     *
     * @param world  The World.
     * @param entity The entity that will be affected.
     */
    public abstract void affectDrinker(FluidVariantWrapper stack, class_1937 world, class_1297 entity);

    /**
     * This method runs before hose is used.
     *
     * @param world  The World.
     * @param entity The entity that will be affected.
     */
    public abstract boolean canExecuteEffect(FluidVariantWrapper stack, class_1937 world, class_1297 entity);
}