package com.tiviacz.travelersbackpack.blockentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.*;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.fabric.api.blockview.v2.RenderDataBlockEntity;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class BackpackBlockEntity extends class_2586 implements class_3908, RenderDataBlockEntity {
    private BackpackWrapper wrapper = BackpackWrapper.DUMMY;
    private boolean isSleepingBagDeployed = false;
    public List<Integer> infiniteAccessUsers = new ArrayList<>();
    public int settingsUser = -1;

    @Nullable
    public class_1657 player;

    public static final String BACKPACK = "Backpack";
    public static final String SLEEPING_BAG = "SleepingBag";
    public static final String SETTINGS_USER = "SettingsUser";

    public BackpackBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.BACKPACK, pos, state);
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public void removeWrapper() {
        this.wrapper = BackpackWrapper.DUMMY;
    }

    @Override
    public void method_11007(class_2487 compound, class_7225.class_7874 pRegistries) {
        super.method_11007(compound, pRegistries);
        writeBackpack(compound, pRegistries);
        compound.method_10556(SLEEPING_BAG, this.isSleepingBagDeployed);
    }

    @Override
    public void method_11014(class_2487 compound, class_7225.class_7874 pRegistries) {
        super.method_11014(compound, pRegistries);
        setBackpackFromNbt(compound, pRegistries);
        if(compound.method_10545(TIER)) {
            setBackpack(getOldDataBackpack(compound, pRegistries), pRegistries);
            compound.method_10551(TIER);
        }
        this.isSleepingBagDeployed = compound.method_10577(SLEEPING_BAG);
        if(compound.method_10545(SETTINGS_USER)) {
            this.settingsUser = compound.method_10550(SETTINGS_USER);
        }
    }

    public void setBackpack(class_1799 backpack, class_7225.class_7874 registryAccess) {
        if(backpack.method_7909() instanceof TravelersBackpackItem) {
            if(this.wrapper == BackpackWrapper.DUMMY) {
                this.wrapper = new BackpackWrapper(backpack.method_7972(), Reference.BLOCK_ENTITY_SCREEN_ID, null, method_10997());
                wrapper.setBackpackPos(method_11016());
                wrapper.saveHandler = () -> {
                    this.method_5431();
                    this.notifyBlockUpdate();
                };
                wrapper.abilityHandler = () -> {
                    if(method_10997() != null) {
                        method_10997().method_8452(method_11016(), method_11010().method_26204());

                        if(method_11010().method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
                            ((TravelersBackpackBlock)method_11010().method_26204()).tryAbsorbWater(method_10997(), method_11016());
                        }
                    }
                };
            } else {
                this.wrapper.setBackpackStack(backpack.method_7972());
            }
        }
    }

    private void setBackpackFromNbt(class_2487 nbt, class_7225.class_7874 pRegistries) {
        setBackpack(class_1799.method_57359(pRegistries, nbt.method_10562(BACKPACK)), pRegistries);
    }

    private void writeBackpack(class_2487 ret, class_7225.class_7874 registries) {
        class_1799 backpackCopy = wrapper.getBackpackStack().method_7972();
        if(backpackCopy.method_7909() instanceof TravelersBackpackItem) {
            ret.method_10566(BACKPACK, backpackCopy.method_57358(registries));
        }
    }

    public class_2350 getBlockDirection() {
        if(field_11863 == null || !(field_11863.method_8320(method_11016()).method_26204() instanceof TravelersBackpackBlock) || !field_11863.method_8320(method_11016()).method_28498(TravelersBackpackBlock.FACING))
            return class_2350.field_11043;
        return field_11863.method_8320(method_11016()).method_11654(TravelersBackpackBlock.FACING);
    }

    public boolean isSleepingBagDeployed() {
        if(getWrapper().hasSleepingBag()) {
            return this.isSleepingBagDeployed;
        }
        return true;
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
        method_5431();
        notifyBlockUpdate();
    }

    public static boolean canPlaceSleepingBag(class_2338 relative, class_1937 level) {
        return level.method_8320(relative).method_45474() && level.method_8621().method_11952(relative);
    }

    public boolean deploySleepingBag(class_1937 level, class_2338 pos) {
        class_2350 direction = this.getBlockDirection();
        this.isThereSleepingBag(direction);

        if(!isSleepingBagDeployed()) {
            class_2338 sleepingBagPos1 = pos.method_10093(direction);
            class_2338 sleepingBagPos2 = sleepingBagPos1.method_10093(direction);

            if(canPlaceSleepingBag(sleepingBagPos1, level) && canPlaceSleepingBag(sleepingBagPos2, level)) {
                if(level.method_8320(sleepingBagPos1.method_10074()).method_26215() || level.method_8320(sleepingBagPos1.method_10074()).method_26204() instanceof class_2404) {
                    return false;
                }
                if(!level.field_9236) {
                    class_2680 sleepingBagState = getProperSleepingBag(getWrapper().getSleepingBagColor());
                    level.method_8652(sleepingBagPos1, sleepingBagState.method_11657(SleepingBagBlock.field_11177, direction).method_11657(SleepingBagBlock.field_9967, class_2742.field_12557).method_11657(SleepingBagBlock.CAN_DROP, false), 3);
                    level.method_8652(sleepingBagPos2, sleepingBagState.method_11657(SleepingBagBlock.field_11177, direction).method_11657(SleepingBagBlock.field_9967, class_2742.field_12560).method_11657(SleepingBagBlock.CAN_DROP, false), 3);

                    level.method_8452(pos, sleepingBagState.method_26204());
                    level.method_8452(sleepingBagPos2, sleepingBagState.method_26204());
                }
                setSleepingBagDeployed(true);
                getWrapper().saveHandler.run();
                return true;
            }
        }
        return false;
    }

    public boolean removeSleepingBag(class_1937 level, class_2350 direction) {
        this.isThereSleepingBag(direction);

        if(isSleepingBagDeployed()) {
            class_2338 sleepingBagPos1 = method_11016().method_10093(direction);
            class_2338 sleepingBagPos2 = sleepingBagPos1.method_10093(direction);

            if(level.method_8320(sleepingBagPos1).method_26204() instanceof SleepingBagBlock && level.method_8320(sleepingBagPos2).method_26204() instanceof SleepingBagBlock) {
                level.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5F, 1.0F);
                level.method_8652(sleepingBagPos2, class_2246.field_10124.method_9564(), 3);
                level.method_8652(sleepingBagPos1, class_2246.field_10124.method_9564(), 3);
                setSleepingBagDeployed(false);
                getWrapper().saveHandler.run();
                return true;
            }
        } else {
            setSleepingBagDeployed(false);
            getWrapper().saveHandler.run();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(class_2350 direction) {
        if(field_11863.method_8320(method_11016().method_10093(direction)).method_26204() instanceof SleepingBagBlock && field_11863.method_8320(method_11016().method_10093(direction).method_10093(direction)).method_26204() instanceof SleepingBagBlock) {
            return true;
        } else {
            setSleepingBagDeployed(false);
            return false;
        }
    }

    public static class_2680 getProperSleepingBag(int sleepingBagColor) {
        return switch(sleepingBagColor) {
            case 0 -> ModBlocks.WHITE_SLEEPING_BAG.method_9564();
            case 1 -> ModBlocks.ORANGE_SLEEPING_BAG.method_9564();
            case 2 -> ModBlocks.MAGENTA_SLEEPING_BAG.method_9564();
            case 3 -> ModBlocks.LIGHT_BLUE_SLEEPING_BAG.method_9564();
            case 4 -> ModBlocks.YELLOW_SLEEPING_BAG.method_9564();
            case 5 -> ModBlocks.LIME_SLEEPING_BAG.method_9564();
            case 6 -> ModBlocks.PINK_SLEEPING_BAG.method_9564();
            case 7 -> ModBlocks.GRAY_SLEEPING_BAG.method_9564();
            case 8 -> ModBlocks.LIGHT_GRAY_SLEEPING_BAG.method_9564();
            case 9 -> ModBlocks.CYAN_SLEEPING_BAG.method_9564();
            case 10 -> ModBlocks.PURPLE_SLEEPING_BAG.method_9564();
            case 11 -> ModBlocks.BLUE_SLEEPING_BAG.method_9564();
            case 12 -> ModBlocks.BROWN_SLEEPING_BAG.method_9564();
            case 13 -> ModBlocks.GREEN_SLEEPING_BAG.method_9564();
            case 14 -> ModBlocks.RED_SLEEPING_BAG.method_9564();
            case 15 -> ModBlocks.BLACK_SLEEPING_BAG.method_9564();
            default -> ModBlocks.RED_SLEEPING_BAG.method_9564();
        };
    }

    @Override
    protected void method_57567(class_9323.class_9324 pComponents) {
        super.method_57567(pComponents);
        pComponents.method_57839(this.wrapper.getBackpackStack().method_7972().method_57353());
    }

    public class_1799 toItemStack(class_1799 stack) {
        stack.method_57365(this.wrapper.getBackpackStack().method_7972().method_57353());
        return stack;
    }

    private void notifyBlockUpdate() {
        if(method_10997() == null) {
            return;
        }
        method_10997().method_8413(method_11016(), method_10997().method_8320(method_11016()), method_10997().method_8320(method_11016()), 3);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper.tickForBlockEntity(backpackBlockEntity);
    }

    @Override
    public class_2561 method_5476() {
        return this.getDefaultName();
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471(method_11010().method_26204().method_9539());
    }

    public void setSettingsUser(class_1657 player) {
        this.settingsUser = player.method_5628();
        notifyBlockUpdate();
    }

    public int getSettingsUser() {
        return this.settingsUser;
    }

    public void removeSettingsUser() {
        this.settingsUser = -1;
        notifyBlockUpdate();
    }

    public boolean canOpenSettings(class_1657 player) {
        if(!player.method_37908().field_9236) {
            return this.settingsUser == player.method_5628();
        } else {
            if(this.settingsUser == -1) {
                return true;
            } else {
                return this.settingsUser == player.method_5628();
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 pRegistries) {
        class_2487 tag = this.method_38244(pRegistries);
        tag.method_10569(SETTINGS_USER, this.settingsUser);
        return tag;
    }

    @Nullable
    @Override
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        if(this.wrapper == BackpackWrapper.DUMMY) {
            throw new IllegalStateException("BackpackWrapper is not initialized!");
        }
        if(canOpenSettings(player)) {
            return new BackpackSettingsMenu(id, inventory, this.wrapper);
        } else {
            return new BackpackBlockEntityMenu(id, inventory, this.infiniteAccessUsers.contains(player.method_5628()) ? player.method_5628() : -1, this.wrapper);
        }
    }

    //Fabric

    public void openBackpack(class_1657 player, class_3908 containerSupplier, class_2338 pos) {
        if(!player.method_37908().field_9236) {
            if(this.infiniteAccessUsers.contains(player.method_5628())) {
                this.infiniteAccessUsers.remove((Object)player.method_5628());
            }
            if(TravelersBackpackConfig.getConfig().backpackSettings.preventMultiplePlayersAccess) {
                if(getWrapper() != BackpackWrapper.DUMMY && !getWrapper().getPlayersUsing().isEmpty()) {
                    return;
                }
            }
            player.method_17355(new ExtendedScreen<>(containerSupplier, saveExtraData(-1, pos)));
        }
    }

    public void openSettings(class_1657 player, class_3908 containerSupplier, class_2338 pos) {
        if(!player.method_37908().field_9236) {
            //Set settings user
            setSettingsUser(player);
            player.method_17355(new ExtendedScreen<>(containerSupplier, saveSettingsExtraData(pos)));
        }
    }

    public void openBackpackFromCommand(class_1657 player, class_3908 containerSupplier, class_2338 pos) {
        if(!player.method_37908().field_9236) {
            //Set user access to infinite if accessing from command
            if(!this.infiniteAccessUsers.contains(player.method_5628())) this.infiniteAccessUsers.add(player.method_5628());
            player.method_17355(new ExtendedScreen<>(containerSupplier, saveExtraData(player.method_5628(), pos)));
        }
    }

    public static ModScreenHandlerTypes.SettingsScreenData saveSettingsExtraData(class_2338 pos) {
        return new ModScreenHandlerTypes.SettingsScreenData(true, Reference.BLOCK_ENTITY_SCREEN_ID, pos, -1);
    }

    public static ModScreenHandlerTypes.BlockEntityScreenData saveExtraData(int entityId, class_2338 pos) {
        return new ModScreenHandlerTypes.BlockEntityScreenData(entityId, pos);
    }

    private record ExtendedScreen<D>(class_3908 containerSupplier, D screenOpeningData) implements ExtendedScreenHandlerFactory<D> {
        @Override
        public D getScreenOpeningData(class_3222 player) {
            return screenOpeningData;
        }

        @Override
        public class_2561 method_5476() {
            return containerSupplier.method_5476();
        }

        @Override
        public @Nullable class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
            return containerSupplier.createMenu(i, inventory, player);
        }
    }

    @Nullable
    @Override
    public Object getRenderData() {
        return new BackpackRenderData(getWrapper().getRenderInfo(), getWrapper().getDyeColor(), isSleepingBagDeployed(), getWrapper().getSleepingBagColor());
    }

    public record BackpackRenderData(RenderInfo info, int dyeColor, boolean isSleepingBagDeployed, int sleepingBagColor) {}

    //Old data helper #TODO for removal
    public class_1799 getOldDataBackpack(class_2487 compound, class_7225.class_7874 registries) {
        class_1799 backpack;
        if(field_11863 != null) {
            backpack = new class_1799(field_11863.method_8320(method_11016()).method_26204().method_8389());
        } else {
            backpack = ModItems.STANDARD_TRAVELERS_BACKPACK.method_7854();
        }
        int tier = Tiers.LEATHER.getOrdinal();

        if(compound.method_10545(TIER)) {
            tier = compound.method_10550(TIER);
            backpack.method_57379(ModDataComponents.TIER, tier);
        }

        BackpackWrapper.initializeSize(backpack);

        int storageSlots = backpack.method_57824(ModDataComponents.STORAGE_SLOTS);
        int toolSlots = backpack.method_57824(ModDataComponents.TOOL_SLOTS);
        int upgradeSlots = backpack.method_57824(ModDataComponents.UPGRADE_SLOTS);
        if(compound.method_10545(INVENTORY)) {
            ItemStackHandler inventory = new ItemStackHandler(99);
            inventory.deserializeNBT(registries, compound.method_10562(INVENTORY));
            backpack.method_57379(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(storageSlots, inventory));
        }
        if(compound.method_10545(TOOLS_INVENTORY)) {
            ItemStackHandler tools = new ItemStackHandler(12);
            tools.deserializeNBT(registries, compound.method_10562(TOOLS_INVENTORY));
            backpack.method_57379(ModDataComponents.TOOLS_CONTAINER, InventoryHelper.itemsToList(toolSlots, tools));
        }
        FluidVariantWrapper leftFluidStack = FluidVariantWrapper.blank();
        FluidVariantWrapper rightFluidStack = FluidVariantWrapper.blank();
        if(compound.method_10545(LEFT_TANK)) {
            FluidTank tank = new FluidTank(20000);
            tank.readNbtOld(registries, compound.method_10562(LEFT_TANK));
            leftFluidStack = new FluidVariantWrapper(tank.variant, tank.amount);
        }
        if(compound.method_10545(RIGHT_TANK)) {
            FluidTank tank = new FluidTank(20000);
            tank.readNbtOld(registries, compound.method_10562(RIGHT_TANK));
            rightFluidStack = new FluidVariantWrapper(tank.variant, tank.amount);
        }

        class_1799 tanksUpgrade = ModItems.TANKS_UPGRADE.method_7854();
        tanksUpgrade.method_57379(ModDataComponents.FLUIDS, new Fluids(leftFluidStack, rightFluidStack));

        ItemStackHandler upgrades = new ItemStackHandler(6);
        upgrades.setStackInSlot(0, tanksUpgrade);
        backpack.method_57379(ModDataComponents.UPGRADES, InventoryHelper.itemsToList(upgradeSlots, upgrades));

        return backpack;
    }

    private static final String TIER = "Tier";
    private static final String INVENTORY = "Inventory";
    private static final String TOOLS_INVENTORY = "ToolsInventory";
    private static final String LEFT_TANK = "LeftTank";
    private static final String RIGHT_TANK = "RightTank";
}