package com.tiviacz.travelersbackpack.blocks;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2970;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.Nullable;

import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class TravelersBackpackBlock extends class_2248 implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;

    public TravelersBackpackBlock(class_2251 builder) {
        super(builder.method_9629(1.0F, Float.MAX_VALUE).method_51369().method_50012(class_3619.field_15971));
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        boolean hasTanks = false;
        if(getter.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
            hasTanks = backpackBlockEntity.getWrapper().tanksVisible();
        }
        return switch(state.method_11654(FACING)) {
            case field_11035 -> hasTanks ? BACKPACK_TANKS_SHAPE_SOUTH : BACKPACK_SHAPE_SOUTH;
            case field_11034 -> hasTanks ? BACKPACK_TANKS_SHAPE_EAST : BACKPACK_SHAPE_EAST;
            case field_11039 -> hasTanks ? BACKPACK_TANKS_SHAPE_WEST : BACKPACK_SHAPE_WEST;
            default -> hasTanks ? BACKPACK_TANKS_SHAPE_NORTH : BACKPACK_SHAPE_NORTH;
        };
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        if(level.field_9236) {
            return class_1269.field_5812;
        } else {
            ((BackpackBlockEntity)level.method_8321(pos)).openBackpack(player, (BackpackBlockEntity)level.method_8321(pos), pos);
            return class_1269.field_21466;
        }
    }

    @Override
    protected void method_55124(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1927 pExplosion, BiConsumer<class_1799, class_2338> pDropConsumer) {
        return; //Do nothing here
    }

    @Override
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if(level.method_8321(pos) instanceof BackpackBlockEntity blockEntity) {
            if(state.method_26204() == ModBlocks.MELON_TRAVELERS_BACKPACK) {
                BackpackAbilities.melonAbility(blockEntity);
            }
            if(player.method_7337()) {
                class_1799 stack = blockEntity.toItemStack(method_8389().method_7854());
                class_1542 itementity = new class_1542(level, (double)pos.method_10263() + 0.5D, (double)pos.method_10264() + 0.5D, (double)pos.method_10260() + 0.5D, stack);
                itementity.method_6988();
                level.method_8649(itementity);
            }
            blockEntity.removeSleepingBag(level, state.method_11654(FACING));
        }
        return super.method_9576(level, pos, state, player);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return this.method_9564().method_11657(FACING, context.method_8042().method_10153());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    protected void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if(!state.method_27852(newState.method_26204())) {
            class_2586 blockentity = level.method_8321(pos);
            super.method_9536(state, level, pos, newState, isMoving);
            if(blockentity instanceof BackpackBlockEntity) {
                level.method_8455(pos, state.method_26204());
            }
        }
    }

    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    protected int method_9572(class_2680 blockState, class_1937 level, class_2338 pos) {
        if(level.method_8321(pos) == null || !(level.method_8321(pos) instanceof BackpackBlockEntity backpack)) {
            return 0;
        } else {
            float f = 0.0F;

            for(int i = 0; i < backpack.getWrapper().getStorage().getSlots(); i++) {
                class_1799 itemstack = backpack.getWrapper().getStorage().getStackInSlot(i);
                if(!itemstack.method_7960()) {
                    f += (float)itemstack.method_7947() / (float)Math.min(backpack.getWrapper().getStorage().getSlotLimit(i), backpack.getWrapper().getStorage().getStackInSlot(i).method_7914());
                }
            }

            f /= (float)backpack.getWrapper().getStorage().getSlots();
            return class_3532.method_53063(f, 0, 15);
        }
    }

    @Override
    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        class_1799 stack = new class_1799(method_8389(), 1);
        if(level.method_8321(pos) instanceof BackpackBlockEntity blockEntity) {
            blockEntity.toItemStack(stack);
        }
        return stack;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BackpackBlockEntity(pos, state);
    }

    //Special

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 || !TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, state.method_26204().method_8389().method_7854()) ? null : BackpackDeathHelper.getTicker(blockEntityType, ModBlockEntityTypes.BACKPACK, BackpackBlockEntity::tick);
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        super.method_9496(state, level, pos, rand);
        if(level.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
            BackpackAbilities.ABILITIES.animateTick(backpackBlockEntity, state, level, pos, rand);
        }
    }

    @Override
    public int method_9524(class_2680 state, class_1922 getter, class_2338 pos, class_2350 direction) {
        if(state.method_26204() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK) {
            if(getter.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity && backpackBlockEntity.getWrapper().isAbilityEnabled()) {
                return 15;
            }
        }
        return super.method_9524(state, getter, pos, direction);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return state.method_26204() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK;
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pMovedByPiston) {
        if(!pOldState.method_27852(pState.method_26204()) && pState.method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.method_9615(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 pLevel, class_2338 pPos, class_2248 pNeighborBlock, class_2338 pNeighborPos, boolean pMovedByPiston) {
        if(state.method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.method_9612(state, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    public void tryAbsorbWater(class_1937 level, class_2338 pos) {
        if(level.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
            backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> {
                if(backpackBlockEntity.getWrapper().isAbilityEnabled()) {
                    if((tanksUpgrade.getLeftTank().isEmpty() || (tanksUpgrade.getLeftTank().getFluid().fluidVariant().getFluid().method_15780(class_3612.field_15910) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity())) || (tanksUpgrade.getRightTank().isEmpty() || (tanksUpgrade.getRightTank().getFluid().fluidVariant().getFluid().method_15780(class_3612.field_15910) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()))) {
                        if(this.removeWaterBreadthFirstSearch(level, pos, tanksUpgrade)) {
                            level.method_20290(2001, pos, class_2248.method_9507(class_2246.field_10382.method_9564()));
                        }
                    }
                }
            });
        }
    }

    private boolean removeWaterBreadthFirstSearch(class_1937 level, class_2338 pos, TanksUpgrade tanksUpgrade) {
        Queue<class_3545<class_2338, Integer>> queue = Lists.newLinkedList();
        queue.add(new class_3545<>(pos, 0));
        int i = 0;

        while(!queue.isEmpty()) {
            class_3545<class_2338, Integer> tuple = queue.poll();
            class_2338 blockpos = tuple.method_15442();
            int j = tuple.method_15441();

            for(class_2350 direction : class_2350.values()) {
                class_2338 blockpos1 = blockpos.method_10093(direction);
                class_2680 blockstate = level.method_8320(blockpos1);
                class_3610 fluidstate = level.method_8316(blockpos1);
                if(fluidstate.method_15767(class_3486.field_15517)) {
                    if(blockstate.method_26204() instanceof class_2263 && !((class_2263)blockstate.method_26204()).method_9700(null, level, blockpos1, blockstate).method_7960()) {
                        ++i;
                        if(tanksUpgrade.getLeftTank().isEmpty() || (tanksUpgrade.getLeftTank().getFluid().fluidVariant().getFluid().method_15780(class_3612.field_15910) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity())) {
                            tanksUpgrade.getLeftTank().fill(new FluidVariantWrapper(FluidVariant.of(class_3612.field_15910), FluidConstants.BUCKET), false);
                        } else {
                            if(tanksUpgrade.getRightTank().isEmpty() || (tanksUpgrade.getRightTank().getFluid().fluidVariant().getFluid().method_15780(class_3612.field_15910) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity())) {
                                tanksUpgrade.getRightTank().fill(new FluidVariantWrapper(FluidVariant.of(class_3612.field_15910), FluidConstants.BUCKET), false);
                            }
                        }
                        if(j < 6) {
                            queue.add(new class_3545<>(blockpos1, j + 1));
                        }
                    } else if(blockstate.method_26204() instanceof class_2404) {
                        level.method_8652(blockpos1, class_2246.field_10124.method_9564(), 3);
                        ++i;
                        if(j < 6) {
                            queue.add(new class_3545<>(blockpos1, j + 1));
                        }
                    } else {

                        if(!blockstate.method_27852(class_2246.field_9993) && !blockstate.method_27852(class_2246.field_10463) && !blockstate.method_27852(class_2246.field_10376) && !blockstate.method_27852(class_2246.field_10238)) {
                            return false;
                        }

                        class_2586 blockentity = blockstate.method_31709() ? level.method_8321(blockpos1) : null;
                        method_9610(blockstate, level, blockpos1, blockentity);
                        level.method_8652(blockpos1, class_2246.field_10124.method_9564(), 3);
                        ++i;
                        if(j < 6) {
                            queue.add(new class_3545<>(blockpos1, j + 1));
                        }
                    }
                }
            }

            if(i > 64) {
                break;
            }
        }

        return i > 0;
    }

    public static final class_265 BACKPACK_TANKS_SHAPE_NORTH = Stream.of(
            // MainBody
            class_2248.method_9541(4.1, 0.8, 7.1, 11.9, 7.8, 11.0),
            // Top
            class_2248.method_9541(4.1, 7.8, 7.1, 11.9, 10.1, 11.0),
            // Bottom
            class_2248.method_9541(4.1, 0.0, 7.9, 11.9, 0.8, 11.0),
            // PocketFace
            class_2248.method_9541(4.9, 2.4, 5.5, 11.1, 7.1, 7.1),
            // LeftStrap
            class_2248.method_9541(10.4, 1.6, 11.0, 11.2, 7.8, 11.8),
            // RightStrap
            class_2248.method_9541(4.8, 1.6, 11.0, 5.6, 7.8, 11.8),
            class_2248.method_9541(1, 0, 7.4, 4.1, 7.8, 10.5),
            class_2248.method_9541(11.9, 0, 7.4, 15, 7.8, 10.5)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public static final class_265 BACKPACK_TANKS_SHAPE_EAST = Stream.of(
            // MainBody
            class_2248.method_9541(5.0, 0.8, 4.1, 8.9, 7.8, 11.9),
            // Top
            class_2248.method_9541(5.0, 7.8, 4.1, 8.9, 10.1, 11.9),
            // Bottom
            class_2248.method_9541(5.0, 0.0, 4.1, 5.9, 0.8, 11.9),
            // PocketFace
            class_2248.method_9541(8.9, 2.4, 4.9, 10.5, 7.1, 11.1),
            // LeftStrap
            class_2248.method_9541(4.2, 1.6, 4.8, 5.0, 7.8, 5.6),
            // RightStrap
            class_2248.method_9541(4.2, 1.6, 10.4, 5.0, 7.8, 11.2),
            class_2248.method_9541(5.5, 0, 1, 8.6, 7.8, 4.1),
            class_2248.method_9541(5.5, 0, 11.9, 8.6, 7.8, 15)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    private static final class_265 BACKPACK_TANKS_SHAPE_SOUTH = Stream.of(
            // MainBody
            class_2248.method_9541(4.1, 0.8, 5.0, 11.9, 7.8, 8.9),
            // Top
            class_2248.method_9541(4.1, 7.8, 5.0, 11.9, 10.1, 8.9),
            // Bottom
            class_2248.method_9541(4.1, 0.0, 5.0, 11.9, 0.8, 8.1),
            // PocketFace
            class_2248.method_9541(4.9, 2.4, 8.9, 11.1, 7.1, 10.5),
            // LeftStrap
            class_2248.method_9541(4.8, 1.6, 4.2, 5.6, 7.8, 5.0),
            // RightStrap
            class_2248.method_9541(10.4, 1.6, 4.2, 11.2, 7.8, 5.0),
            class_2248.method_9541(1, 0, 5.5, 4.1, 7.8, 8.6),
            class_2248.method_9541(11.9, 0, 5.5, 15, 7.8, 8.6)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public static final class_265 BACKPACK_TANKS_SHAPE_WEST = Stream.of(
            // MainBody
            class_2248.method_9541(7.1, 0.8, 4.1, 11.0, 7.8, 11.9),
            // Top
            class_2248.method_9541(7.1, 7.8, 4.1, 11.0, 10.1, 11.9),
            // Bottom
            class_2248.method_9541(7.9, 0.0, 4.1, 11.0, 0.8, 11.9),
            // PocketFace
            class_2248.method_9541(5.5, 2.4, 4.9, 7.1, 7.1, 11.1),
            // LeftStrap
            class_2248.method_9541(11.0, 1.6, 10.4, 11.8, 7.8, 11.2),
            // RightStrap
            class_2248.method_9541(11.0, 1.6, 4.8, 11.8, 7.8, 5.6),
            class_2248.method_9541(7.4, 0, 1, 10.5, 7.8, 4.1),
            class_2248.method_9541(7.4, 0, 11.9, 10.5, 7.8, 15)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public static final class_265 BACKPACK_SHAPE_NORTH = Stream.of(
            // MainBody
            class_2248.method_9541(4.1, 0.8, 7.1, 11.9, 7.8, 11.0),
            // Top
            class_2248.method_9541(4.1, 7.8, 7.1, 11.9, 10.1, 11.0),
            // Bottom
            class_2248.method_9541(4.1, 0.0, 7.9, 11.9, 0.8, 11.0),
            // PocketFace
            class_2248.method_9541(4.9, 2.4, 5.5, 11.1, 7.1, 7.1),
            // LeftStrap
            class_2248.method_9541(10.4, 1.6, 11.0, 11.2, 7.8, 11.8),
            // RightStrap
            class_2248.method_9541(4.8, 1.6, 11.0, 5.6, 7.8, 11.8)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public static final class_265 BACKPACK_SHAPE_EAST = Stream.of(
            // MainBody
            class_2248.method_9541(5.0, 0.8, 4.1, 8.9, 7.8, 11.9),
            // Top
            class_2248.method_9541(5.0, 7.8, 4.1, 8.9, 10.1, 11.9),
            // Bottom
            class_2248.method_9541(5.0, 0.0, 4.1, 5.9, 0.8, 11.9),
            // PocketFace
            class_2248.method_9541(8.9, 2.4, 4.9, 10.5, 7.1, 11.1),
            // LeftStrap
            class_2248.method_9541(4.2, 1.6, 4.8, 5.0, 7.8, 5.6),
            // RightStrap
            class_2248.method_9541(4.2, 1.6, 10.4, 5.0, 7.8, 11.2)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public static final class_265 BACKPACK_SHAPE_SOUTH = Stream.of(
            // MainBody
            class_2248.method_9541(4.1, 0.8, 5.0, 11.9, 7.8, 8.9),
            // Top
            class_2248.method_9541(4.1, 7.8, 5.0, 11.9, 10.1, 8.9),
            // Bottom
            class_2248.method_9541(4.1, 0.0, 5.0, 11.9, 0.8, 8.1),
            // PocketFace
            class_2248.method_9541(4.9, 2.4, 8.9, 11.1, 7.1, 10.5),
            // LeftStrap
            class_2248.method_9541(4.8, 1.6, 4.2, 5.6, 7.8, 5.0),
            // RightStrap
            class_2248.method_9541(10.4, 1.6, 4.2, 11.2, 7.8, 5.0)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public static final class_265 BACKPACK_SHAPE_WEST = Stream.of(
            // MainBody
            class_2248.method_9541(7.1, 0.8, 4.1, 11.0, 7.8, 11.9),
            // Top
            class_2248.method_9541(7.1, 7.8, 4.1, 11.0, 10.1, 11.9),
            // Bottom
            class_2248.method_9541(7.9, 0.0, 4.1, 11.0, 0.8, 11.9),
            // PocketFace
            class_2248.method_9541(5.5, 2.4, 4.9, 7.1, 7.1, 11.1),
            // LeftStrap
            class_2248.method_9541(11.0, 1.6, 10.4, 11.8, 7.8, 11.2),
            // RightStrap
            class_2248.method_9541(11.0, 1.6, 4.8, 11.8, 7.8, 5.6)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    //Fabric

    public static void registerDispenserBehaviour() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem)
                .forEach(item -> class_2315.method_10009(item, new class_2970()));
    }
}