package com.tiviacz.travelersbackpack.client.model;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class BackpackBakedQuadCollector {
    private final class_1087 backpack;
    private final class_1087 dyedBackpack;

    //Base backpack
    private final List<class_777> baseQuads;
    //Base dyed backpack
    private final List<class_777> dyedBaseQuads;

    //Sleeping Bag, Tanks
    private final List<class_777> sleepingBagExtrasQuads;
    private final List<class_777> sleepingBagQuads;
    private final List<class_777> tanksQuads;

    //Noses, Horns
    private final List<class_777> foxNose;
    private final List<class_777> wolfNose;
    private final List<class_777> wardenHorns;
    private final List<class_777> ocelotNose;
    private final List<class_777> villagerNose;
    private final List<class_777> pigNose;

    public BackpackBakedQuadCollector(class_1087 backpack, class_1087 dyedBackpack) {
        this.backpack = backpack;
        this.dyedBackpack = dyedBackpack;

        this.baseQuads = new ArrayList<>();
        this.dyedBaseQuads = new ArrayList<>();
        this.sleepingBagExtrasQuads = new ArrayList<>();
        this.sleepingBagQuads = new ArrayList<>();
        this.tanksQuads = new ArrayList<>();

        //Noses, Horns
        this.foxNose = new ArrayList<>();
        this.wolfNose = new ArrayList<>();
        this.wardenHorns = new ArrayList<>();
        this.ocelotNose = new ArrayList<>();
        this.villagerNose = new ArrayList<>();
        this.pigNose = new ArrayList<>();
    }

    public void collectBakedQuads(@Nullable class_2680 state, class_5819 random) {
        this.baseQuads.clear();
        this.dyedBaseQuads.clear();
        this.tanksQuads.clear();
        this.sleepingBagExtrasQuads.clear();
        this.sleepingBagQuads.clear();

        //Noses, Horns
        this.foxNose.clear();
        this.wolfNose.clear();
        this.wardenHorns.clear();
        this.ocelotNose.clear();
        this.villagerNose.clear();
        this.pigNose.clear();

        for(class_777 quad : backpack.method_4707(state, null, random)) {
            int tintIndex = quad.method_3359();
            if(tintIndex < 100) {
                baseQuads.add(quad);
            } else if(tintIndex == 100) {
                tanksQuads.add(quad);
            } else if(tintIndex == 101) {
                sleepingBagExtrasQuads.add(quad);
            } else if(tintIndex == 102) {
                foxNose.add(quad);
            } else if(tintIndex == 103) {
                wolfNose.add(quad);
            } else if(tintIndex == 104) {
                wardenHorns.add(quad);
            } else if(tintIndex == 105) {
                ocelotNose.add(quad);
            } else if(tintIndex == 106) {
                pigNose.add(quad);
            } else if(tintIndex == 107) {
                villagerNose.add(quad);
            } else if(tintIndex == 108) {
                sleepingBagQuads.add(quad);
            }
        }

        if(dyedBaseQuads.isEmpty()) {
            for(class_777 quad : dyedBackpack.method_4707(state, null, random)) {
                if(quad.method_3359() < 100) {
                    dyedBaseQuads.add(quad);
                }
            }
        }
    }

    public class_1087 getBackpackBakedModel() {
        return backpack;
    }

    public class_1087 getDyedBackpackBakedModel() {
        return dyedBackpack;
    }

    public List<class_777> getBaseQuads() {
        return baseQuads;
    }

    public List<class_777> getDyedBaseQuads() {
        return dyedBaseQuads;
    }

    public List<class_777> getSleepingBagExtrasQuads() {
        return sleepingBagExtrasQuads;
    }

    public List<class_777> getSleepingBagQuads() {
        return sleepingBagQuads;
    }

    public List<class_777> getTanksQuads() {
        return tanksQuads;
    }

    public List<class_777> getFoxNose() {
        return foxNose;
    }

    public List<class_777> getWolfNose() {
        return wolfNose;
    }

    public List<class_777> getWardenHorns() {
        return wardenHorns;
    }

    public List<class_777> getOcelotNose() {
        return ocelotNose;
    }

    public List<class_777> getPigNose() {
        return pigNose;
    }

    public List<class_777> getVillagerNose() {
        return villagerNose;
    }
}