package com.tiviacz.travelersbackpack.client.screens;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_465;

public abstract class AbstractBackpackScreen<T extends AbstractBackpackMenu> extends class_465<T> {
    public static final class_2960 BACKGROUND_11 = class_2960.method_60655(TravelersBackpack.MODID, "textures/gui/background_11.png");
    public static final class_2960 BACKGROUND_9 = class_2960.method_60655(TravelersBackpack.MODID, "textures/gui/background_9.png");
    public static final class_2960 SLOTS = class_2960.method_60655(TravelersBackpack.MODID, "textures/gui/slots.png");
    public static final class_2960 TANKS = class_2960.method_60655(TravelersBackpack.MODID, "textures/gui/tanks.png");
    public static final class_2960 ICONS = class_2960.method_60655(TravelersBackpack.MODID, "textures/gui/icons.png");
    public static final class_2960 TABS = class_2960.method_60655(TravelersBackpack.MODID, "textures/gui/tabs.png");
    public static final int TOP_BAR_OFFSET = 17;
    public int slotCount;
    public boolean wider = false;
    protected final BackpackWrapper wrapper;

    public InventoryScroll scroll = null;
    public int slotYPos;
    public boolean isScrollable = false;
    public int scrollAmount = 0; //0 - Top
    public static final int HEIGHT_WITHOUT_STORAGE = 114;
    public int slotsHeight;
    public int visibleSlots;
    public int visibleRows;

    protected AbstractBackpackScreen(T pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.wrapper = pMenu.getWrapper();

        this.field_25268 = 6;
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public class_1657 getScreenPlayer() {
        return method_17577().player;
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public void updateDimensions() {
        int guiScaledHeight = class_310.method_1551().method_22683().method_4502();
        if(guiScaledHeight < field_2779) {
            int displayableNumberOfRows = Math.min((guiScaledHeight - HEIGHT_WITHOUT_STORAGE) / 18, getRows());
            int newImageHeight = HEIGHT_WITHOUT_STORAGE + calculateSlotHeight(displayableNumberOfRows);

            this.slotsHeight = calculateSlotHeight(displayableNumberOfRows);
            this.visibleSlots = displayableNumberOfRows * (this.slotCount > 81 ? 11 : 9);
            this.field_2779 = newImageHeight;
            this.visibleRows = displayableNumberOfRows;
            this.isScrollable = true;
        }
    }

    public void updateBackpackSlotsPosition() {
        int allStorageSlots = field_2797.BACKPACK_INV_END;
        if(this.isScrollable) {
            int scrollAmount = this.scrollAmount;
            int hiddenSlotsFirst = scrollAmount * getSlotsInRow();
            int movedSlots = (this.visibleRows * getSlotsInRow()) - hiddenSlotsFirst; //Start from firstYPos
            int revealedSlots = scrollAmount * getSlotsInRow();
            int lastRowSlots = this.slotCount % getSlotsInRow();

            if(scrollAmount == getMaxScrollAmount() && lastRowSlots > 0) {
                revealedSlots -= getSlotsInRow();
                revealedSlots += lastRowSlots;
            }

            for(int i = 0; i < hiddenSlotsFirst; i++) {
                field_2797.field_7761.get(i).field_7872 = -1000;
            }
            int countSlots = 0;
            for(int i = hiddenSlotsFirst; i < hiddenSlotsFirst + movedSlots; i++) {
                field_2797.field_7761.get(i).field_7872 = slotYPos + (int)Math.floor((double)countSlots / getSlotsInRow()) * 18;
                countSlots++;
            }
            countSlots = 0;
            int lastY = slotYPos + (this.visibleRows - scrollAmount) * 18;
            for(int i = hiddenSlotsFirst + movedSlots; i < hiddenSlotsFirst + movedSlots + revealedSlots; i++) {
                field_2797.field_7761.get(i).field_7872 = lastY + (int)Math.floor((double)countSlots / getSlotsInRow()) * 18;
                countSlots++;
            }
            for(int i = hiddenSlotsFirst + movedSlots + revealedSlots; i < allStorageSlots; i++) {
                field_2797.field_7761.get(i).field_7872 = -1000;
            }
        }
    }

    public void updatePlayerSlotsPosition() {
        if(this.isScrollable) {
            int firstPlayerSlotY = 15 + TOP_BAR_OFFSET + (this.visibleRows * 18);
            //Inventory
            int countSlots = 0;
            for(int i = field_2797.PLAYER_INV_START; i < field_2797.PLAYER_HOT_END - 9; i++) {
                field_2797.field_7761.get(i).field_7872 = firstPlayerSlotY + (int)Math.floor((double)countSlots / 9) * 18;
                countSlots++;
            }
            //Hotbar
            for(int i = field_2797.PLAYER_HOT_END - 9; i < field_2797.PLAYER_HOT_END; i++) {
                field_2797.field_7761.get(i).field_7872 = firstPlayerSlotY + (3 * 18) + 4;
            }
        }
    }

    public int calculateSlotHeight(int displayableRows) {
        return displayableRows * 18;
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)slotCount / rowSlots);
        return rows * 18;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.slotCount / getSlotsInRow());
    }

    public int getSlotsInRow() {
        return this.wider ? 11 : 9;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public int getMaxScrollAmount() {
        return (int)Math.ceil((double)this.slotCount / getSlotsInRow()) - (int)Math.ceil((double)this.visibleSlots / getSlotsInRow());
    }

    public void renderInventoryBackground(class_332 guiGraphics, int x, int y, class_2960 texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.method_25302(texture, x, y, 0, 0, xSize, TOP_BAR_OFFSET + halfSlotHeight);
        int playerInventoryHeight = 98;
        guiGraphics.method_25302(texture, x, y + TOP_BAR_OFFSET + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(class_332 guiGraphics, int x, int y, int slotCount) {
        int lastSlotRow = this.slotCount % getSlotsInRow();
        int visibleRows = this.visibleRows;
        int fullRows = this.isScrollable ? visibleRows : slotCount / getSlotsInRow();

        if(this.isScrollable && this.scrollAmount == getMaxScrollAmount()) {
            if(lastSlotRow > 0) {
                fullRows--;
            }
        }

        //Full Rows
        guiGraphics.method_25302(SLOTS, x, y, 0, 0, getSlotsInRow() * 18, fullRows * 18);
        if(fullRows > 9) {
            guiGraphics.method_25302(SLOTS, x, y + (9 * 18), 0, 0, getSlotsInRow() * 18, (fullRows - 9) * 18);
        }

        //Last Row
        if(lastSlotRow > 0) {
            if(this.isScrollable) {
                if(this.scrollAmount == getMaxScrollAmount()) {
                    guiGraphics.method_25302(SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
                }
            } else {
                guiGraphics.method_25302(SLOTS, x, y + fullRows * 18, 0, 0, lastSlotRow * 18, 18);
            }
        }
    }

    public void renderLockedBackpackSlot(class_332 guiGraphics) {
        if(field_2797.disabledSlotIndex > 0 && field_2797.disabledSlotIndex < field_2797.field_7761.size()) {
            if(field_2797.method_7611(field_2797.disabledSlotIndex) instanceof DisabledSlot slot) {
                int x = field_2776 + slot.field_7873;
                int y = field_2800 + slot.field_7872;
                guiGraphics.method_48196(class_1921.method_51785(), x, y, x + 16, y + 16, 0, (0xFF << 24) | (0x68 << 16) | (0x68 << 8) | 0x68);
            }
        }
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        drawUnsortableSlots(guiGraphics);
        drawMemorySlots(guiGraphics);
    }

    public abstract void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks);

    public abstract void drawUnsortableSlots(class_332 guiGraphics);

    public abstract void drawMemorySlots(class_332 guiGraphics);

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if(this.scroll != null) {
            return this.scroll.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for(class_364 child : method_25396()) {
            if(child.method_25405(mouseX, mouseY) && child.method_25403(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_364 focused = method_25399();
        if(focused != null && !focused.method_25405(mouseX, mouseY) && (focused instanceof WidgetBase widgetBase)) {
            widgetBase.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void sendDataToServer() {

    }

    public void playUIClickSound() {
        field_2797.getPlayerInventory().field_7546.method_37908().method_8396(field_2797.getPlayerInventory().field_7546, field_2797.getPlayerInventory().field_7546.method_24515(), class_3417.field_15015.comp_349(), class_3419.field_15250, 0.25F, 1.0F);
    }

    //Fabric

    public int getGuiLeft() {
        return field_2776;
    }

    public int getGuiTop() {
        return field_2800;
    }
}