package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.*;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.Reference;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3936;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class BackpackSettingsScreen extends AbstractBackpackScreen<BackpackSettingsMenu> implements class_3936<BackpackSettingsMenu> {
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    public SupporterBadgeWidget supporterBadgeWidget; //Supporters Only!! :)
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<>();
    public List<Pair<Integer, Pair<class_1799, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<class_1799, Boolean>>> memorySlots = new ArrayList<>();
    public boolean visibility;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, class_1661 inventory, class_2561 component) {
        super(backpackSettingsMenu, inventory, backpackSettingsMenu.getWrapper().getBackpackScreenTitle());
        //Init called internally
        recalculate();

        //Update position
        updateBackpackSlotsPosition();
        updatePlayerSlotsPosition();

        this.lastUnsortableSlots = new ArrayList<>(wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<>(wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<>(this.lastMemorySlots);
        this.visibility = wrapper.getBackpackStack().method_57825(ModDataComponents.IS_VISIBLE, true);

        this.field_25267 = 8;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        initWidgets();
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);

        this.isScrollable = false;
        recalculate();
        method_25426();
        method_17577().updateSlots();

        //Update position
        updateBackpackSlotsPosition();
        updatePlayerSlotsPosition();
    }

    public void recalculate() {
        this.method_37067();

        this.slotCount = getWrapper().getStorage().getSlots();
        this.visibleSlots = this.slotCount;
        this.slotsHeight = calculateSlotHeight(slotCount > 81);

        this.field_2776 = 0;
        this.field_2800 = 0;

        boolean wideTexture = slotCount > 81;
        this.wider = wideTexture;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / getSlotsInRow());
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? 212 : 176;
        this.field_2779 = TOP_BAR_OFFSET + this.slotsHeight + playerInventoryHeight;

        updateDimensions();

        this.field_25270 = 3 + TOP_BAR_OFFSET + (this.visibleRows * 18);
        this.field_25269 = 8;
        this.field_25267 = 8;
        this.field_25268 = 6;

        if(wideTexture) {
            this.field_25269 += 18;
        }

        //Cache first slot Y pos, ignore if not visible
        if(field_2797.method_7611(0).field_7872 >= 0) {
            this.slotYPos = field_2797.method_7611(0).field_7872;
        }
    }

    @Override
    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        //Render Widgets underBg
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));

        boolean wideTexture = slotCount > 81;
        renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, field_2792, this.slotsHeight);

        int slotsXOffset = 7;

        //Render Widgets aboveBg
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        renderSlots(guiGraphics, x + slotsXOffset, y + TOP_BAR_OFFSET, this.slotCount);
        renderLockedBackpackSlot(guiGraphics);
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), true);
        method_37063(this.settingsWidget);

        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1));
        method_37063(this.unsortablesWidget);

        this.memoryWidget = new MemoryWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1), false);
        method_37063(this.memoryWidget);

        if(getWrapper().getScreenID() == Reference.WEARABLE_SCREEN_ID) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            method_37063(this.visibilityWidget);

            if(getWrapper().isOwner(this.getScreenPlayer()) && Supporters.SUPPORTERS_REFERENCE.contains(this.getScreenPlayer().method_7334().getName())) {
                this.supporterBadgeWidget = new SupporterBadgeWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 24 + 1));
                method_37063(this.supporterBadgeWidget);
            }
        }

        if(this.isScrollable) {
            int scrollXPos = field_2776 + 7; //leftPos + (wider ? 27 : 9) + (tanksVisible ? 22 : (wider ? 0 : 18));
            this.scroll = new InventoryScroll(this, class_310.method_1551(), 4, this.visibleRows * 18, field_2800 + TOP_BAR_OFFSET, scrollXPos + getSlotsInRow() * 18);
            if(this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            method_37063(this.scroll);
        }
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.method_25396().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<SettingsWidgetBase> widgets = (List<SettingsWidgetBase>)this.method_25396().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for(int i = 0; i < widgets.size(); i++) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = widgets.get(i);
            if(i > 0) {
                previousWidget = widgets.get(i - 1);
            }
            if(previousWidget == null) {
                continue;
            }
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    @Override
    public void drawUnsortableSlots(class_332 guiGraphics) {
        if(this.unsortablesWidget.isTabOpened()) {
            if(!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + method_17577().method_7611(i).field_7873, this.getGuiTop() + method_17577().method_7611(i).field_7872, 25, 55, 16, 16));
            }
        } else {
            if(!this.lastUnsortableSlots.isEmpty()) {
                this.lastUnsortableSlots.forEach(i -> guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + method_17577().method_7611(i).field_7873, this.getGuiTop() + method_17577().method_7611(i).field_7872, 25, 55, 16, 16));
            }
        }
    }

    @Override
    public void drawMemorySlots(class_332 guiGraphics) {
        if(this.memoryWidget.isTabOpened()) {
            if(!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if(pair.getSecond().getSecond()) {
                        guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872, 25, 73, 16, 16);
                    } else {
                        guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872, 25, 91, 16, 16);
                    }

                    if(method_17577().method_7611(pair.getFirst()).method_7677().method_7960()) {
                        class_1799 itemstack = pair.getSecond().getFirst();
                        guiGraphics.method_51445(itemstack, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872);
                        guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873 + 16, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872 + 16, 822083583);
                    }
                });
            }
        } else {
            if(!this.lastMemorySlots.isEmpty()) {
                this.lastMemorySlots.forEach(pair -> {
                    if(method_17577().method_7611(pair.getFirst()).method_7677().method_7960()) {
                        class_1799 itemstack = pair.getSecond().getFirst();
                        guiGraphics.method_51445(itemstack, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872);
                        guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873 + 16, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872 + 16, 822083583);
                    }
                });
            }
        }
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 type) {
        //Selecting or unselecting unsortable slots by clicking the single slot
        if(selectSlots(slot, button)) {
            return;
        }
        super.method_2383(slot, slotId, button, type);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        class_1735 slot = this.field_2787; //.getSlotUnderMouse();
        //Selecting or unselecting unsortable and memory slots by dragging mouse cursor
        if(selectSlots(slot, button)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean selectSlots(class_1735 slot, int button) {
        if(slot != null && slot.field_7874 >= 0 && slot.field_7874 < wrapper.getStorage().getSlots()) {
            if(this.unsortablesWidget.isTabOpened()) {
                if(button == 0 && !this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.add(slot.field_7874);
                    return true;
                }

                if(button == 1 && this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.remove((Object)slot.field_7874);
                    return true;
                }
            }

            if(this.memoryWidget.isTabOpened()) {
                if(button == 0 && !this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    if(slot.method_7677().method_7960()) {
                        return false;
                    }
                    this.memorySlots.add(Pair.of(slot.field_7874, Pair.of(this.memoryWidget.matchComponents ? slot.method_7677() : slot.method_7677().method_7909().method_7854(), this.memoryWidget.matchComponents)));
                    return true;
                }

                if(button == 1 && this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> p.getFirst() == slot.field_7874);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void method_25419() {
        //Send Data to server if closed with ESC
        this.sendDataToServer();
        super.method_25419();
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if(KeybindHandler.OPEN_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if(playerEntity != null) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }
}