package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class AbilitySliderButton extends Button {
    private final boolean isBlock;

    public AbilitySliderButton(BackpackScreen screen, boolean isBlock, int xOffset) {
        super(screen, screen.getWidthAdditions() + 145 - xOffset, screen.getMiddleBar(), 12, 12);
        this.isBlock = isBlock;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if(isBlock) {
            drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        } else {
            if(ComponentUtils.isWearingBackpack(screen.method_17577().getPlayerInventory().field_7546)) {
                drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
            }
        }
    }

    public void drawButton(class_332 guiGraphics, int mouseX, int mouseY, class_2960 texture) {
        if(screen.getWrapper().isAbilityEnabled()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 44, 56, 78, 82);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 44, 67, 78, 82);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(inButton(mouseX, mouseY)) {
            //If disabled in config
            if(!BackpackAbilities.isAbilityEnabledInConfig(screen.getWrapper().getBackpackStack())) {
                guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
                return;
            }
            List<class_2561> components = new ArrayList<>();

            //Ability on/off
            if(screen.getWrapper().isAbilityEnabled()) {
                components.add(class_2561.method_43471("screen.travelersbackpack.ability_enabled"));
            } else {
                components.add(class_2561.method_43471("screen.travelersbackpack.ability_disabled"));
            }

            //Show cooldown
            if(BackpackAbilities.hasCooldown(screen.getWrapper().getBackpackStack())) {
                components.add(class_2561.method_43469("screen.travelersbackpack.ability_cooldown", TextUtils.getConvertedTime(screen.getWrapper().getCooldown())));
            } else {
                components.add(class_2561.method_43471("screen.travelersbackpack.ability_ready"));
            }

            guiGraphics.method_51437(screen.getFont(), components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if(!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.isAbilityEnabledInConfig(screen.getWrapper().getBackpackStack())) {
            return false;
        }

        if(isBlock) {
            if(BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.ABILITY_SLIDER, !screen.getWrapper().isAbilityEnabled());
                screen.playUIClickSound();
                return true;
            }
        } else {
            if(BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.ABILITY_SLIDER, !screen.getWrapper().isAbilityEnabled());
                screen.playUIClickSound();
                return true;
            }
        }
        return false;
    }
}