package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5632;

public class BackpackTooltipComponent implements class_5632 {
    protected List<class_1799> storage = new ArrayList<>();
    protected List<class_1799> upgrades = new ArrayList<>();
    protected List<class_1799> tools = new ArrayList<>();
    protected FluidVariantWrapper leftFluidStack = CommonFluid.empty();
    protected FluidVariantWrapper rightFluidStack = CommonFluid.empty();
    protected final boolean hoveredWithItem;

    public BackpackTooltipComponent(class_1799 stack) {
        this(stack, false);
    }

    public BackpackTooltipComponent(class_1799 stack, boolean hoveredWithItem) {
        this.loadComponentData(stack);
        this.hoveredWithItem = hoveredWithItem;
    }

    public boolean isHoveredWithItem() {
        return this.hoveredWithItem;
    }

    public void loadComponentData(class_1799 stack) {
        this.loadFluidStacks(stack);
        this.storage = this.loadStorage(stack);
        this.upgrades = this.loadUpgrades(stack);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(stack);
    }

    public void loadFluidStacks(class_1799 stack) {
        if(stack.method_57826(ModDataComponents.RENDER_INFO)) {
            RenderInfo info = stack.method_57824(ModDataComponents.RENDER_INFO);
            this.leftFluidStack = info.getLeftFluidStack();
            this.rightFluidStack = info.getRightFluidStack();
        }
    }

    public List<class_1799> loadStorage(class_1799 stack) {
        if(stack.method_57826(ModDataComponents.BACKPACK_CONTAINER)) {
            return new ArrayList<>(stack.method_57824(ModDataComponents.BACKPACK_CONTAINER).getItems().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<>();
    }

    public List<class_1799> loadUpgrades(class_1799 stack) {
        if(stack.method_57826(ModDataComponents.UPGRADES)) {
            return new ArrayList<>(stack.method_57824(ModDataComponents.UPGRADES).getItems().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<>();
    }

    public List<class_1799> mergeStacks(List<class_1799> stacks) {
        if(!stacks.isEmpty()) {
            List<class_1799> uniqueList = new ArrayList<>();
            for(class_1799 stack : stacks) {
                if(uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for(int i = 0; i < uniqueList.size(); i++) {
                    if(class_1799.method_31577(stack, uniqueList.get(i))) {
                        int count = stack.method_7947() + uniqueList.get(i).method_7947();
                        uniqueList.set(i, stack.method_46651(count));
                        flag = true;
                        break;
                    }
                }
                if(!flag) {
                    uniqueList.add(stack);
                }
            }
            //Split >999 stacks
            List<class_1799> splittedList = new ArrayList<>();

            for(class_1799 itemStack : uniqueList) {
                if(itemStack.method_7947() > 999) {
                    int count = itemStack.method_7947();
                    int c = count / 999;
                    int reminder = count % 999;

                    for(int j = 0; j < c; j++) {
                        splittedList.add(itemStack.method_46651(999));
                    }
                    splittedList.add(itemStack.method_46651(reminder));
                } else {
                    splittedList.add(itemStack);
                }
            }
            return splittedList;
        }
        return new ArrayList<>();
    }

    public List<class_1799> loadTools(class_1799 stack) {
        if(stack.method_57826(ModDataComponents.TOOLS_CONTAINER)) {
            return new ArrayList<>(stack.method_57824(ModDataComponents.TOOLS_CONTAINER).getItems().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<>();
    }
}