package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class ToolSlotsWidget extends WidgetBase<BackpackScreen> {
    private final int xPos;

    public ToolSlotsWidget(BackpackScreen screen, Point pos, int xPos) {
        super(screen, pos, 10, 10);
        this.xPos = xPos;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if(method_25405(mouseX, mouseY)) {
            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() - 1, pos.y() - 1, 78, 82, width + 2, height + 2);
        }
        if(!screen.getWrapper().showToolSlots()) {
            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x(), pos.y(), 4, 24, width, height);
        } else {
            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x(), pos.y(), 4, 34, width, height);
            renderToolsAddition(guiGraphics, screen.getWrapper().getTools().getSlots(), pos.x() - 130 - xPos, pos.y() + 16 + 10 - 19);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if(method_25405(mouseX, mouseY)) {
            ServerboundActionTagPacket.create(ServerboundActionTagPacket.SHOW_TOOL_SLOTS, !screen.getWrapper().showToolSlots());
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(method_25405(mouseX, mouseY)) {
            if(screen.getWrapper().showToolSlots()) {
                guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.hide_tool_slots"), mouseX, mouseY);
            } else {
                guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.show_tool_slots"), mouseX, mouseY);
            }
        }
    }

    public void renderToolsAddition(class_332 guiGraphics, int size, int x, int y) {
        //Top bar
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y, 0, 67, 23, 5);

        //Middle
        for(int i = 0; i < size; i++) {
            guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 5 + (i * 18), 0, 72, 23, 18);
        }

        //Bottom bar
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 5 + (size * 18), 0, 90, 23, 5);
    }
}