package com.tiviacz.travelersbackpack.client.screens.widgets.settings;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.SupporterBadgePacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class SupporterBadgeWidget extends SettingsWidgetBase {
    private final Point iconUv = new Point(132, 72);
    private final Point iconEnabledUv = new Point(132, 54);

    public SupporterBadgeWidget(BackpackSettingsScreen screen, Point pos) {
        super(screen, pos, new Point(24, 24));
    }

    public void sendDataToServer() {
        boolean showSupporterStar = TravelersBackpackConfig.getConfig().client.showSupporterBadge;
        TravelersBackpackConfig.getConfig().client.showSupporterBadge = !showSupporterStar;
        TravelersBackpackConfig.saveConfig();
        PacketDistributor.sendToServer(new SupporterBadgePacket.Serverbound(!showSupporterStar));
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        Point uv = TravelersBackpackConfig.getConfig().client.showSupporterBadge ? iconEnabledUv : iconUv;
        guiGraphics.method_25302(BackpackScreen.ICONS, pos.x(), pos.y(), emptyTabUv.x(), emptyTabUv.y(), width, height); //Empty Tab
        guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + 3, pos.y() + 3, uv.x(), uv.y(), iconSize.x(), iconSize.y()); //Icon
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(isMouseOverIcon(mouseX, mouseY)) {
            List<class_2561> tooltip = new ArrayList<>();
            tooltip.add(class_2561.method_43471("screen.travelersbackpack.toggle_supporter_badge_visibility"));
            tooltip.add(class_2561.method_43470("Thanks for your support! :) - Tiviacz1337"));
            guiGraphics.method_51437(screen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if(isMouseOverIcon(pMouseX, pMouseY)) {
            //Send data to server if changed
            sendDataToServer();
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}