package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ClearCommand {
    public ClearCommand(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        LiteralArgumentBuilder<class_2168> tbCommand = class_2170.method_9247("tb").requires(player -> player.method_9259(2));

        tbCommand.then(class_2170.method_9247("remove")
                .executes(source -> removeBackpack(source.getSource(), source.getSource().method_9207()))
                .then(class_2170.method_9244("player", class_2186.method_9305())
                        .executes(source -> removeBackpack(source.getSource(), class_2186.method_9315(source, "player")))));

        tbCommand.then(class_2170.method_9247("clear")
                .executes(source -> clearBackpack(source.getSource(), source.getSource().method_9207()))
                .then(class_2170.method_9244("player", class_2186.method_9305())
                        .executes(source -> clearBackpack(source.getSource(), class_2186.method_9315(source, "player")))));

        dispatcher.register(tbCommand);
    }

    private static int removeBackpack(class_2168 source, class_3222 player) {
        if(ComponentUtils.isWearingBackpack(player)) {
            if(TravelersBackpack.enableIntegration()) return -1;

            ComponentUtils.getComponent(player).ifPresent(data -> {
                if(!player.method_7270(data.getBackpack().method_7972())) {
                    player.method_7328(data.getBackpack().method_7972(), true);
                }
                data.equipBackpack(class_1799.field_8037);
                data.synchronise();
            });
            source.method_9226(() -> class_2561.method_43470("Removed Traveler's Backpack from " + player.method_5476().getString() + " and added copy to inventory"), true);
            return 1;
        } else {
            source.method_9213(class_2561.method_43470("Player " + player.method_5476().getString() + " is not wearing backpack"));
            return -1;
        }
    }

    private static int clearBackpack(class_2168 source, class_3222 player) {
        if(ComponentUtils.isWearingBackpack(player)) {
            if(TravelersBackpack.enableIntegration()) return -1;

            ComponentUtils.getComponent(player).ifPresent(data -> {
                class_1799 stack = data.getBackpack().method_7972();
                if(!player.method_7270(stack.method_7972())) {
                    player.method_7328(stack.method_7972(), true);
                }
                int tier = stack.method_57825(ModDataComponents.TIER, 0);
                class_1799 clearedStack = stack.method_7909().method_7854();
                clearedStack.method_57379(ModDataComponents.TIER, tier);
                data.equipBackpack(clearedStack);
                data.synchronise();
            });
            source.method_9226(() -> class_2561.method_43470("Cleared contents of Traveler's Backpack from " + player.method_5476().getString() + " and added copy to inventory"), true);
            return 1;
        } else {
            source.method_9213(class_2561.method_43470("Player " + player.method_5476().getString() + " is not wearing backpack"));
            return -1;
        }
    }
}