package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;

public class ShapedBackpackRecipeBuilder implements class_5797 {
    private final class_7800 category;
    private final class_1792 result;
    private final int count;
    private final class_1799 resultStack; // Neo: add stack result support
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap<>();
    private String group;
    private boolean showNotification = true;

    public ShapedBackpackRecipeBuilder(class_7800 pCategory, class_1935 pResult, int pCount) {
        this(pCategory, new class_1799(pResult, pCount));
    }

    public ShapedBackpackRecipeBuilder(class_7800 p_249996_, class_1799 result) {
        this.category = p_249996_;
        this.result = result.method_7909();
        this.count = result.method_7947();
        this.resultStack = result;
    }

    /**
     * Creates a new builder for a shaped recipe.
     */
    public static ShapedBackpackRecipeBuilder shaped(class_7800 pCategory, class_1935 pResult) {
        return shaped(pCategory, pResult, 1);
    }

    /**
     * Creates a new builder for a shaped recipe.
     */
    public static ShapedBackpackRecipeBuilder shaped(class_7800 pCategory, class_1935 pResult, int pCount) {
        return new ShapedBackpackRecipeBuilder(pCategory, pResult, pCount);
    }

    public static ShapedBackpackRecipeBuilder shaped(class_7800 p_251325_, class_1799 result) {
        return new ShapedBackpackRecipeBuilder(p_251325_, result);
    }

    /**
     * Adds a key to the recipe pattern.
     */
    public ShapedBackpackRecipeBuilder define(Character pSymbol, class_6862<class_1792> pTag) {
        return this.define(pSymbol, class_1856.method_8106(pTag));
    }

    /**
     * Adds a key to the recipe pattern.
     */
    public ShapedBackpackRecipeBuilder define(Character pSymbol, class_1935 pItem) {
        return this.define(pSymbol, class_1856.method_8091(pItem));
    }

    /**
     * Adds a key to the recipe pattern.
     */
    public ShapedBackpackRecipeBuilder define(Character pSymbol, class_1856 pIngredient) {
        if(this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        } else if(pSymbol == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        } else {
            this.key.put(pSymbol, pIngredient);
            return this;
        }
    }

    /**
     * Adds a new entry to the patterns for this recipe.
     */
    public ShapedBackpackRecipeBuilder pattern(String pPattern) {
        if(!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        } else {
            this.rows.add(pPattern);
            return this;
        }
    }

    public ShapedBackpackRecipeBuilder method_33530(String pName, class_175<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public ShapedBackpackRecipeBuilder method_33529(String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ShapedBackpackRecipeBuilder showNotification(boolean pShowNotification) {
        this.showNotification = pShowNotification;
        return this;
    }

    @Override
    public class_1792 method_36441() {
        return this.result;
    }

    @Override
    public void method_17972(class_8790 pRecipeOutput, class_2960 pId) {
        class_8957 shapedrecipepattern = this.ensureValid(pId);
        class_161.class_162 advancement$builder = pRecipeOutput.method_53818()
                .method_705("has_the_recipe", class_2119.method_27847(pId))
                .method_703(class_170.class_171.method_753(pId))
                .method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach(advancement$builder::method_705);
        ShapedBackpackRecipe shapedbackpackrecipe = new ShapedBackpackRecipe(
                Objects.requireNonNullElse(this.group, ""),
                class_5797.method_55308(this.category),
                shapedrecipepattern,
                this.resultStack,
                this.showNotification
        );
        pRecipeOutput.method_53819(pId, shapedbackpackrecipe, advancement$builder.method_695(pId.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private class_8957 ensureValid(class_2960 pLocation) {
        if(this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pLocation);
        } else {
            return class_8957.method_55085(this.key, this.rows);
        }
    }
}
