package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.Reference;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;

@EmiEntrypoint
public class EmiCompat implements EmiPlugin {
    @Override
    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addExclusionArea(BackpackSettingsScreen.class, ((screen, consumer) -> {
            screen.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(widget -> {
                int[] size = ((WidgetBase)widget).getWidgetSizeAndPos();
                consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
            });
        }));

        emiRegistry.addExclusionArea(BackpackScreen.class, ((screen, consumer) -> {
            int[] s = screen.settingsWidget.getWidgetSizeAndPos();
            consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));

            screen.method_25396().stream().filter(w -> w instanceof UpgradeWidgetBase).forEach(widget -> {
                int[] size = ((UpgradeWidgetBase)widget).getWidgetSizeAndPos();
                consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
            });
            screen.upgradeSlots.forEach(slot -> {
                if(!slot.isHidden()) {
                    int[] size = slot.getUpgradeSlotSizeAndPos();
                    consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
                }
            });
        }));

        emiRegistry.addRecipeHandler(ModScreenHandlerTypes.BACKPACK_BLOCK_MENU, new GridMenuInfo<>());
        emiRegistry.addRecipeHandler(ModScreenHandlerTypes.BACKPACK_MENU, new GridMenuInfo<>());
    }

    private static class GridMenuInfo<T extends BackpackBaseMenu> implements StandardRecipeHandler<T> {
        @Override
        public @Nullable class_1735 getOutputSlot(T handler) {
            return handler.method_7611(handler.CRAFTING_RESULT);
        }

        @Override
        public List<class_1735> getInputSources(T handler) {
            List<class_1735> list = new ArrayList<>();
            //Backpack Inv
            for(int i = 0; i < handler.BACKPACK_INV_END; i++) {
                list.add(handler.method_7611(i));
            }
            //Player Inv
            for(int i = handler.PLAYER_INV_START; i < handler.PLAYER_HOT_END; i++) {
                if(handler.getWrapper().getScreenID() == Reference.ITEM_SCREEN_ID && handler.method_7611(i) instanceof DisabledSlot)
                    continue;

                list.add(handler.method_7611(i));
            }
            return list;
        }

        @Override
        public List<class_1735> getCraftingSlots(T handler) {
            List<class_1735> list = new ArrayList<>();
            CraftingUpgrade upgrade = handler.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).get();
            if(upgrade.isTabOpened()) {
                int firstCraftSlot = handler.CRAFTING_GRID_START;
                for(int i = 0; i < 9; i++) {
                    list.add(handler.method_7611(firstCraftSlot + i));
                }
            }
            return list;
        }

        @Override
        public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
            CraftingUpgrade upgrade = context.getScreenHandler().getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).get();
            if(!upgrade.isTabOpened()) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, upgrade.getDataHolderSlot(), true, ServerActions.TAB_OPEN);
                return false;
            }
            return StandardRecipeHandler.super.craft(recipe, context);
        }

        @Override
        public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
            return StandardRecipeHandler.super.canCraft(recipe, context) && context.getScreenHandler().getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent();
        }

        @Override
        public boolean supportsRecipe(EmiRecipe recipe) {
            return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
        }
    }
}