package com.tiviacz.travelersbackpack.compat.jei;

import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.class_1735;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BlockEntityTransferInfo implements IRecipeTransferInfo<BackpackBlockEntityMenu, class_8786<class_3955>> {
    @Override
    public Class<? extends BackpackBlockEntityMenu> getContainerClass() {
        return BackpackBlockEntityMenu.class;
    }

    @Override
    public Optional<class_3917<BackpackBlockEntityMenu>> getMenuType() {
        return Optional.of(ModScreenHandlerTypes.BACKPACK_BLOCK_MENU);
    }

    @Override
    public RecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Override
    public boolean canHandle(BackpackBlockEntityMenu menu, class_8786<class_3955> recipe) {
        return menu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent() && menu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).get().isTabOpened();
    }

    @Override
    public List<class_1735> getRecipeSlots(BackpackBlockEntityMenu menu, class_8786<class_3955> recipe) {
        List<class_1735> list = new ArrayList<>();
        int firstCraftSlot = menu.CRAFTING_GRID_START;
        for(int i = 0; i < 9; i++) {
            list.add(menu.method_7611(firstCraftSlot + i));
        }
        return list;
    }

    @Override
    public List<class_1735> getInventorySlots(BackpackBlockEntityMenu menu, class_8786<class_3955> recipe) {
        List<class_1735> list = new ArrayList<>();
        //Backpack Inv
        for(int i = 0; i < menu.BACKPACK_INV_END; i++) {
            list.add(menu.method_7611(i));
        }
        //Player Inv
        for(int i = menu.PLAYER_INV_START; i < menu.PLAYER_HOT_END; i++) {
            list.add(menu.method_7611(i));
        }
        return list;
    }
}