package com.tiviacz.travelersbackpack.compat.polymorph;

import com.illusivesoulworks.polymorph.api.client.PolymorphWidgets;
import com.illusivesoulworks.polymorph.common.PolymorphRecipeManager;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingContainerImproved;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import java.util.Optional;

public class PolymorphCompat {
    public static boolean shouldResetRecipe(class_8786<class_3955> current, BackpackBaseMenu menu, CraftingContainerImproved craftSlots, class_1937 level, class_1657 player) {
        PolymorphRecipeManager manager = new PolymorphRecipeManager();
        Optional<class_8786<class_3955>> optional = manager.getPlayerRecipe(menu, class_3956.field_17545, craftSlots.method_59961(), level, player);
        return optional.filter(craftingRecipe -> craftingRecipe != current).isPresent();
    }

    public static class_8786<class_3955> getPolymorphedRecipe(BackpackBaseMenu menu, CraftingContainerImproved craftSlots, class_1937 level, class_1657 player) {
        PolymorphRecipeManager manager = new PolymorphRecipeManager();
        Optional<class_8786<class_3955>> optional = manager.getPlayerRecipe(menu, class_3956.field_17545, craftSlots.method_59961(), level, player);
        return optional.orElse(null);
    }

    @Environment(EnvType.CLIENT)
    public static void registerWidget() {
        PolymorphWidgets.getInstance().registerWidget(screen -> {
            if(screen instanceof BackpackScreen backpackScreen) {
                for(var slot : backpackScreen.method_17577().field_7761) {
                    if(slot instanceof ResultSlotExt) {
                        return new PolymorphWidget(backpackScreen, slot);
                    }
                }
            }
            return null;
        });
    }
}
