package com.tiviacz.travelersbackpack.compat.toughasnails;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3612;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;

public class ToughAsNailsWaterEffect extends EffectFluid {
    public ToughAsNailsWaterEffect() {
        super("toughasnails:water", class_3612.field_15910, FluidConstants.BUCKET);
    }

    @Override
    public void affectDrinker(FluidVariantWrapper fluidStack, class_1937 level, class_1297 entity) {
        if(entity instanceof class_1657 player) {
            if(ModConfig.thirst.enableThirst && !level.field_9236) {
                //Data for bucket
                IThirst thirst = ThirstHelper.getThirst(player);
                int drink_thirst = 3 * 5;
                float drink_hydration = 0.4F;
                float drink_poison_chance = 0.25F;
                thirst.drink(drink_thirst, drink_hydration);

                if(level.field_9229.method_43057() < drink_poison_chance) {
                    player.method_6092(new class_1293(TANEffects.THIRST, 600));
                }
            }
        }
    }

    @Override
    public boolean canExecuteEffect(FluidVariantWrapper stack, class_1937 level, class_1297 entity) {
        return stack.getAmount() >= amountRequired;
    }
}
