package com.tiviacz.travelersbackpack.compat.trinkets;

import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_7923;

public class TravelersBackpackTrinket implements Trinket {
    public static void init() {
        class_7923.field_41178.method_10220()
                .filter(item -> item instanceof TravelersBackpackItem)
                .forEach(item -> TrinketsApi.registerTrinket(item, new TravelersBackpackTrinket()));
    }

    @Environment(EnvType.CLIENT)
    public static void initClient() {
        class_7923.field_41178.method_10220()
                .filter(item -> item instanceof TravelersBackpackItem)
                .forEach(item -> TrinketRendererRegistry.registerRenderer(item, new Renderer()));
    }

    @Override
    public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        return TravelersBackpackConfig.getConfig().backpackSettings.backSlotIntegration;
    }

    @Override
    public boolean canEquipFromUse(class_1799 stack, class_1309 entity) {
        return false;
    }

    @Override
    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if(!TravelersBackpackConfig.getConfig().backpackSettings.backSlotIntegration) return;
        if(entity instanceof class_1657 player) {
            BackpackWrapper.tick(stack, player, true);
        }
    }

    @Environment(EnvType.CLIENT)
    public static class Renderer implements TrinketRenderer {
        @Override
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
            if(entity instanceof class_1657 player && contextModel instanceof class_591<?> playerModel) {
                class_1799 backpackStack = ComponentUtils.getWearingBackpack(player);
                BackpackLayer.renderBackpackLayer(playerModel, poseStack, multiBufferSource, light, player, backpackStack);
            }
        }
    }
}