package com.tiviacz.travelersbackpack.component;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.attachment.AttachmentUtils;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9323;
import org.ladysnake.cca.api.v3.component.ComponentProvider;

import java.util.ArrayList;
import java.util.List;

public class TravelersBackpackComponent implements ITravelersBackpack {
    private final String BACKPACK = "Wearable";
    public final class_1657 player;
    public BackpackWrapper backpackWrapper;
    public class_1799 backpack = new class_1799(class_1802.field_8162, 0);

    public TravelersBackpackComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.method_7909() instanceof TravelersBackpackItem;
    }

    @Override
    public class_1799 getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(class_1799 stack) {
        this.remove();
        if(!(stack.method_7909() instanceof TravelersBackpackItem)) return;

        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, Reference.WEARABLE_SCREEN_ID, this.player, this.player.method_37908());
        this.backpackWrapper.setBackpackOwner(this.player);

        //Update client
        synchronise();

        //Data transfer
        AttachmentUtils.getAttachment(player).ifPresent(itb -> itb.equipBackpack(stack, player));
    }

    @Override
    public void updateBackpack(class_1799 stack) {
        if(this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);

            //Data transfer
            AttachmentUtils.getAttachment(player).ifPresent(itb -> itb.updateBackpack(stack, this.player));
        } else {
            equipBackpack(stack);
        }
    }

    @Override
    public void applyComponents(class_9323 map) {
        if(this.backpackWrapper != null) {
            this.backpack.method_57365(map);
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeWearable() {
        this.backpack = new class_1799(class_1802.field_8162, 0);
    }

    @Override
    public void removeWrapper() {
        if(this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove() {
        removeWearable();
        removeWrapper();

        //Update client to remove old backpack wrapper
        if(this.player.method_37908() != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync(this.player, (buf, recipient) -> writeSyncPacket(getBackpack(), buf, recipient, true));

            //Sync to watching clients
            for(class_3222 recipient : PlayerLookup.tracking(this.player)) {
                if(recipient.method_5628() == this.player.method_5628()) {
                    continue;
                }
                ComponentUtils.WEARABLE.syncWith(recipient, (ComponentProvider)this.player, (buf, rec) -> writeSyncPacket(getBackpack(), buf, rec, true), p -> true);
            }
        }

        //Data transfer
        AttachmentUtils.getAttachment(player).ifPresent(itb -> itb.remove(player));
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise() {
        if(player != null && !player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync(this.player);

            //Sync to watching clients
            for(class_3222 recipient : PlayerLookup.tracking(this.player)) {
                if(recipient.method_5628() == this.player.method_5628()) {
                    continue;
                }
                ComponentUtils.WEARABLE.syncWith(recipient, (ComponentProvider)this.player, (buf, rec) -> writeSyncPacket(buf, rec), p -> true);
            }
        }
    }

    @Override
    public void synchronise(class_9323 map) {
        if(player != null && !player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync(this.player, (buf, recipient) -> writeComponentPacket(buf, recipient, map));

            //Sync to watching clients
            for(class_3222 recipient : PlayerLookup.tracking(this.player)) {
                if(recipient.method_5628() == this.player.method_5628()) {
                    continue;
                }
                ComponentUtils.WEARABLE.syncWith(recipient, (ComponentProvider)this.player, (buf, rec) -> writeComponentPacket(buf, rec, map), p -> true);
            }
        }
    }

    /**
     * Saving on server
     *
     * @param compoundTag    a {@code NbtCompound} on which this component's serializable data has been written
     * @param registryLookup access to dynamic registry data
     */
    @Override
    public void readFromNbt(class_2487 compoundTag, class_7225.class_7874 registryLookup) {
        class_1799 backpack = class_1799.method_57359(registryLookup, compoundTag.method_10562(BACKPACK));
        equipBackpack(backpack);
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2487 compound = new class_2487();
        if(hasBackpack()) {
            class_1799 backpack = getBackpack();
            compound = (class_2487)backpack.method_57375(registryLookup);
        }
        tag.method_10566(BACKPACK, compound);
    }

    /**
     * Helper methods to write sync packets
     *
     * @param buf
     * @param recipient
     * @param map
     */
    public void writeComponentPacket(class_9129 buf, class_3222 recipient, class_9323 map) {
        buf.method_53002(1);
        class_9135.method_56896(class_9323.field_50234).encode(buf, map);
    }

    public void writeSyncPacket(class_1799 backpack, class_9129 buf, class_3222 recipient, boolean removeData) {
        class_1799 backpackCopy = backpack.method_7972();
        if(backpackCopy.method_57826(ModDataComponents.BACKPACK_CONTAINER)) {
            backpackCopy.method_57381(ModDataComponents.BACKPACK_CONTAINER);
        }
        //Client needs only visual representation, no need to send the whole data
        if(backpackCopy.method_57826(ModDataComponents.SLOTS)) {
            Slots slots = backpackCopy.method_57824(ModDataComponents.SLOTS);
            List<Pair<Integer, Pair<class_1799, Boolean>>> memorizedStacksHeavy = slots.memory();
            List<Pair<Integer, Pair<class_1799, Boolean>>> reduced = new ArrayList<>();

            for(Pair<Integer, Pair<class_1799, Boolean>> outerPair : memorizedStacksHeavy) {
                int index = outerPair.getFirst();
                class_1799 innerStack = outerPair.getSecond().getFirst().method_7972();
                boolean matchComponents = outerPair.getSecond().getSecond();
                if(matchComponents) {
                    innerStack = new class_1799(innerStack.method_7909(), innerStack.method_7947());
                }
                if(innerStack.method_7960()) {
                    continue;
                }
                reduced.add(Pair.of(index, Pair.of(innerStack, matchComponents)));
            }
            backpackCopy.method_57379(ModDataComponents.SLOTS, new Slots(slots.unsortables(), reduced));
        }
        buf.method_53002(0);
        buf.method_52964(removeData);
        class_1799.field_49268.encode(buf, backpackCopy);
    }

    /**
     * Client synchronization packets
     *
     * @param buf       the buffer to write the data to
     * @param recipient the player to which the packet will be sent
     */
    @Override
    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        this.writeSyncPacket(getBackpack(), buf, recipient, false);
    }

    @Override
    public void applySyncPacket(class_9129 buf) {
        int type = buf.readInt();
        if(type == 0) {
            boolean removeData = buf.readBoolean();
            class_1799 backpackStack = class_1799.field_49268.decode(buf);
            if(removeData) {
                remove();
            } else {
                updateBackpack(backpackStack);
            }

        } else {
            class_9323 map = class_9135.method_56896(class_9323.field_50234).decode(buf);
            if(map != null) {
                applyComponents(map);
            }
        }
    }
}
