package com.tiviacz.travelersbackpack.config;

import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import java.util.*;

public class TravelersBackpackConfig {
    public static TravelersBackpackConfigData getConfig() {
        return AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).getConfig();
    }

    public static void saveConfig() {
        AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).save();
    }

    public static void register() {
        AutoConfig.register(TravelersBackpackConfigData.class, JanksonConfigSerializer::new);

        // Listen for when the server is reloading (i.e. /reload), and reload the config
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((s, m) -> AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).load());

        //Register Config load listener
        AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).registerLoadListener((holder, config) -> {

            //Abilities
            BackpackAbilities.ALLOWED_ABILITIES.clear();
            loadItemsFromConfig(TravelersBackpackConfig.getConfig().backpackAbilities.allowedAbilities, com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES);

            //Load Backpack Effects
            BackpackAbilities.getBackpackEffects().clear();
            loadBackpackEffectsFromConfig(config.backpackAbilities.backpackEffects, com.tiviacz.travelersbackpack.common.BackpackAbilities.BACKPACK_EFFECTS);

            //Update allowed abilities if added effect
            com.tiviacz.travelersbackpack.common.BackpackAbilities.getBackpackEffects().entries().stream().forEach(entry -> {
                if(!com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES.contains(entry.getKey())) {
                    com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES.add(entry.getKey());
                }
                if(!com.tiviacz.travelersbackpack.common.BackpackAbilities.ITEM_ABILITIES_LIST.contains(entry.getKey())) {
                    com.tiviacz.travelersbackpack.common.BackpackAbilities.ITEM_ABILITIES_LIST.add(entry.getKey());
                }
            });

            //Remove all abilities that are not allowed //#TODO probably tweak
            List<class_1792> allowed = new ArrayList<>(BackpackAbilities.ALLOWED_ABILITIES);
            BackpackAbilities.ITEM_ABILITIES_LIST.removeIf(item -> !allowed.contains(item));
            BackpackAbilities.BLOCK_ABILITIES_LIST.removeIf(item -> !allowed.contains(item));

            //Cooldowns
            BackpackAbilities.getCooldowns().clear();
            loadCooldownsFromConfig(config.backpackAbilities.cooldowns, com.tiviacz.travelersbackpack.common.BackpackAbilities.COOLDOWNS);

            return class_1269.field_5812;
        });
    }

    public static boolean isToolAllowed(class_1799 value) {
        return isOnItemList(value, getConfig().backpackSettings.toolSlotsAcceptableItems);
    }

    public static boolean isItemBlacklisted(class_1799 value) {
        return isOnItemList(value, getConfig().backpackSettings.blacklistedItems);
    }

    public static boolean isOverworldEntityTypePossible(class_1297 value) {
        return isOnEntityList(value, getConfig().world.possibleOverworldEntityTypes);
    }

    public static boolean isNetherEntityTypePossible(class_1297 value) {
        return isOnEntityList(value, getConfig().world.possibleOverworldEntityTypes);
    }

    public static boolean isOnEntityList(class_1297 value, String[] list) {
        return Arrays.stream(list).anyMatch(p -> p.equals(class_7923.field_41177.method_10221(value.method_5864()).toString()));
    }

    public static boolean isOnItemList(class_1799 value, String[] list) {
        return Arrays.stream(list).anyMatch(p -> p.equals(class_7923.field_41178.method_10221(value.method_7909()).toString()));
    }

    public static class_1792 getRandomCompatibleOverworldBackpackEntry(class_5819 random) {
        String[] backpacks = getConfig().world.overworldBackpacks;
        String selectedBackpack = backpacks[random.method_43048(backpacks.length)];

        return class_7923.field_41178.method_17966(class_2960.method_12829(selectedBackpack)).orElseThrow(() -> new NoSuchElementException("Wrong backpack registry name specified in the config!"));
    }

    public static class_1792 getRandomCompatibleNetherBackpackEntry(class_5819 random) {
        String[] backpacks = getConfig().world.netherBackpacks;
        String selectedBackpack = backpacks[random.method_43048(backpacks.length)];

        return class_7923.field_41178.method_17966(class_2960.method_12829(selectedBackpack)).orElseThrow(() -> new NoSuchElementException("Wrong backpack registry name specified in the config!"));
    }

    public static class_2487 writeToNbt() {
        TravelersBackpackConfigData data = getConfig();
        class_2487 nbt = new class_2487();

        //Backpack Upgrades
        nbt.method_10556("backpackUpgrades.enableTanksUpgrade", data.backpackUpgrades.enableTanksUpgrade);
        nbt.method_10556("backpackUpgrades.enableCraftingUpgrade", data.backpackUpgrades.enableCraftingUpgrade);
        nbt.method_10556("backpackUpgrades.enableFurnaceUpgrade", data.backpackUpgrades.enableFurnaceUpgrade);
        nbt.method_10556("backpackUpgrades.enableSmokerUpgrade", data.backpackUpgrades.enableSmokerUpgrade);
        nbt.method_10556("backpackUpgrades.enableBlastFurnaceUpgrade", data.backpackUpgrades.enableBlastFurnaceUpgrade);
        nbt.method_10556("backpackUpgrades.enableJukeboxUpgrade", data.backpackUpgrades.enableJukeboxUpgrade);
        //Pickup
        nbt.method_10556("backpackUpgrades.pickupUpgradeSettings.enableUpgrade", data.backpackUpgrades.pickupUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.pickupUpgradeSettings.filterSlotCount", data.backpackUpgrades.pickupUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.pickupUpgradeSettings.slotsInRow", data.backpackUpgrades.pickupUpgradeSettings.slotsInRow);
        //Magnet
        nbt.method_10556("backpackUpgrades.magnetUpgradeSettings.enableUpgrade", data.backpackUpgrades.magnetUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.filterSlotCount", data.backpackUpgrades.magnetUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.slotsInRow", data.backpackUpgrades.magnetUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.pullRange", data.backpackUpgrades.magnetUpgradeSettings.pullRange);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.tickRate", data.backpackUpgrades.magnetUpgradeSettings.tickRate);
        //Feeding
        nbt.method_10556("backpackUpgrades.feedingUpgradeSettings.enableUpgrade", data.backpackUpgrades.feedingUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.filterSlotCount", data.backpackUpgrades.feedingUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.slotsInRow", data.backpackUpgrades.feedingUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.tickRate", data.backpackUpgrades.feedingUpgradeSettings.tickRate);
        //Refill
        nbt.method_10556("backpackUpgrades.refillUpgradeSettings.enableUpgrade", data.backpackUpgrades.refillUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.refillUpgradeSettings.filterSlotCount", data.backpackUpgrades.refillUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.refillUpgradeSettings.slotsInRow", data.backpackUpgrades.refillUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackUpgrades.refillUpgradeSettings.tickRate", data.backpackUpgrades.refillUpgradeSettings.tickRate);
        //Void
        nbt.method_10556("backpackUpgrades.voidUpgradeSettings.enableUpgrade", data.backpackUpgrades.voidUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.voidUpgradeSettings.filterSlotCount", data.backpackUpgrades.voidUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.voidUpgradeSettings.slotsInRow", data.backpackUpgrades.voidUpgradeSettings.slotsInRow);

        //Backpack Settings

        //Leather
        nbt.method_10569("backpackSettings.leather.inventorySlotCount", data.backpackSettings.leather.inventorySlotCount);
        nbt.method_10569("backpackSettings.leather.upgradeSlotCount", data.backpackSettings.leather.upgradeSlotCount);
        nbt.method_10569("backpackSettings.leather.toolSlotCount", data.backpackSettings.leather.toolSlotCount);
        nbt.method_10544("backpackSettings.leather.tankCapacityPerRow", data.backpackSettings.leather.tankCapacityPerRow);
        //Iron
        nbt.method_10569("backpackSettings.iron.inventorySlotCount", data.backpackSettings.iron.inventorySlotCount);
        nbt.method_10569("backpackSettings.iron.upgradeSlotCount", data.backpackSettings.iron.upgradeSlotCount);
        nbt.method_10569("backpackSettings.iron.toolSlotCount", data.backpackSettings.iron.toolSlotCount);
        nbt.method_10544("backpackSettings.iron.tankCapacityPerRow", data.backpackSettings.iron.tankCapacityPerRow);
        //Gold
        nbt.method_10569("backpackSettings.gold.inventorySlotCount", data.backpackSettings.gold.inventorySlotCount);
        nbt.method_10569("backpackSettings.gold.upgradeSlotCount", data.backpackSettings.gold.upgradeSlotCount);
        nbt.method_10569("backpackSettings.gold.toolSlotCount", data.backpackSettings.gold.toolSlotCount);
        nbt.method_10544("backpackSettings.gold.tankCapacityPerRow", data.backpackSettings.gold.tankCapacityPerRow);
        //Diamond
        nbt.method_10569("backpackSettings.diamond.inventorySlotCount", data.backpackSettings.diamond.inventorySlotCount);
        nbt.method_10569("backpackSettings.diamond.upgradeSlotCount", data.backpackSettings.diamond.upgradeSlotCount);
        nbt.method_10569("backpackSettings.diamond.toolSlotCount", data.backpackSettings.diamond.toolSlotCount);
        nbt.method_10544("backpackSettings.diamond.tankCapacityPerRow", data.backpackSettings.diamond.tankCapacityPerRow);
        //Netherite
        nbt.method_10569("backpackSettings.netherite.inventorySlotCount", data.backpackSettings.netherite.inventorySlotCount);
        nbt.method_10569("backpackSettings.netherite.upgradeSlotCount", data.backpackSettings.netherite.upgradeSlotCount);
        nbt.method_10569("backpackSettings.netherite.toolSlotCount", data.backpackSettings.netherite.toolSlotCount);
        nbt.method_10544("backpackSettings.netherite.tankCapacityPerRow", data.backpackSettings.netherite.tankCapacityPerRow);

        nbt.method_10556("backpackSettings.rightClickEquip", data.backpackSettings.rightClickEquip);
        nbt.method_10556("backpackSettings.rightClickUnequip", data.backpackSettings.rightClickUnequip);
        nbt.method_10556("backpackSettings.allowOnlyEquippedBackpack", data.backpackSettings.allowOnlyEquippedBackpack);
        nbt.method_10556("backpackSettings.allowOpeningFromSlot", data.backpackSettings.allowOpeningFromSlot);
        nbt.method_10556("backpackSettings.preventMultiplePlayersAccess", data.backpackSettings.preventMultiplePlayersAccess);
        nbt.method_10556("backpackSettings.invulnerableBackpack", data.backpackSettings.invulnerableBackpack);
        nbt.method_10582("backpackSettings.toolSlotsAcceptableItems", String.join(",", data.backpackSettings.toolSlotsAcceptableItems));
        nbt.method_10582("backpackSettings.blacklistedItems", String.join(",", data.backpackSettings.blacklistedItems));
        nbt.method_10556("backpackSettings.toolSlotsAcceptEverything", data.backpackSettings.toolSlotsAcceptEverything);
        nbt.method_10556("backpackSettings.allowShulkerBoxes", data.backpackSettings.allowShulkerBoxes);
        nbt.method_10556("backpackSettings.voidProtection", data.backpackSettings.voidProtection);
        nbt.method_10556("backpackSettings.backpackDeathPlace", data.backpackSettings.backpackDeathPlace);
        nbt.method_10556("backpackSettings.backpackForceDeathPlace", data.backpackSettings.backpackForceDeathPlace);
        nbt.method_10556("backpackSettings.quickSleepingBag", data.backpackSettings.quickSleepingBag);
        nbt.method_10556("backpackSettings.enableSleepingBagSpawnPoint", data.backpackSettings.enableSleepingBagSpawnPoint);
        nbt.method_10556("backpackSettings.backSlotIntegration", data.backpackSettings.backSlotIntegration);

        //World
        nbt.method_10556("world.enableLoot", data.world.enableLoot);
        nbt.method_10548("world.chance", data.world.chance);
        nbt.method_10556("world.spawnEntitiesWithBackpack", data.world.spawnEntitiesWithBackpack);
        nbt.method_10582("world.possibleOverworldEntityTypes", String.join(",", data.world.possibleOverworldEntityTypes));
        nbt.method_10582("world.possibleNetherEntityTypes", String.join(",", data.world.possibleNetherEntityTypes));
        nbt.method_10582("world.overworldBackpacks", String.join(",", data.world.overworldBackpacks));
        nbt.method_10582("world.netherBackpacks", String.join(",", data.world.netherBackpacks));
        nbt.method_10556("world.enableVillagerTrade", data.world.enableVillagerTrade);

        //Backpack Abilities
        nbt.method_10556("backpackAbilities.enableBackpackAbilities", data.backpackAbilities.enableBackpackAbilities);
        nbt.method_10556("backpackAbilities.forceAbilityEnabled", data.backpackAbilities.forceAbilityEnabled);
        nbt.method_10582("backpackAbilities.allowedAbilities", String.join(",", data.backpackAbilities.allowedAbilities));
        nbt.method_10582("backpackAbilities.backpackEffects", String.join(",", data.backpackAbilities.backpackEffects));
        nbt.method_10582("backpackAbilities.cooldowns", String.join(",", data.backpackAbilities.cooldowns));

        //Slowness Debuff
        nbt.method_10556("slownessDebuff.tooManyBackpacksSlowness", data.slownessDebuff.tooManyBackpacksSlowness);
        nbt.method_10569("slownessDebuff.maxNumberOfBackpacks", data.slownessDebuff.maxNumberOfBackpacks);
        nbt.method_10569("slownessDebuff.slownessPerExcessedBackpack", data.slownessDebuff.slownessPerExcessedBackpack);

        return nbt;
    }

    public static TravelersBackpackConfigData readFromNbt(class_2487 nbt) {
        TravelersBackpackConfigData client = getConfig();
        TravelersBackpackConfigData data = new TravelersBackpackConfigData();

        //Client

        //Overlay
        data.client.overlay.enableOverlay = client.client.overlay.enableOverlay;
        data.client.overlay.offsetX = client.client.overlay.offsetX;
        data.client.overlay.offsetY = client.client.overlay.offsetY;

        data.client.showBackpackIconInInventory = client.client.showBackpackIconInInventory;
        data.client.sendBackpackCoordinatesMessage = client.client.sendBackpackCoordinatesMessage;
        data.client.enableToolCycling = client.client.enableToolCycling;
        data.client.disableScrollWheel = client.client.disableScrollWheel;
        data.client.obtainTips = client.client.obtainTips;
        data.client.renderTools = client.client.renderTools;
        data.client.showSupporterBadge = client.client.showSupporterBadge;

        if(nbt == null) {
            return data;
        }

        data.backpackUpgrades.enableTanksUpgrade = nbt.method_10577("backpackUpgrades.enableTanksUpgrade");
        data.backpackUpgrades.enableCraftingUpgrade = nbt.method_10577("backpackUpgrades.enableCraftingUpgrade");
        data.backpackUpgrades.enableFurnaceUpgrade = nbt.method_10577("backpackUpgrades.enableFurnaceUpgrade");
        data.backpackUpgrades.enableSmokerUpgrade = nbt.method_10577("backpackUpgrades.enableSmokerUpgrade");
        data.backpackUpgrades.enableBlastFurnaceUpgrade = nbt.method_10577("backpackUpgrades.enableBlastFurnaceUpgrade");
        data.backpackUpgrades.enableJukeboxUpgrade = nbt.method_10577("backpackUpgrades.enableJukeboxUpgrade");

        data.backpackUpgrades.pickupUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.pickupUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.pickupUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.pickupUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.pickupUpgradeSettings.slotsInRow = nbt.method_10550("backpackUpgrades.pickupUpgradeSettings.slotsInRow");

        data.backpackUpgrades.magnetUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.magnetUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.magnetUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.magnetUpgradeSettings.slotsInRow = nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.slotsInRow");
        data.backpackUpgrades.magnetUpgradeSettings.pullRange = nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.pullRange");
        data.backpackUpgrades.magnetUpgradeSettings.tickRate = nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.tickRate");

        data.backpackUpgrades.feedingUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.feedingUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.feedingUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.feedingUpgradeSettings.slotsInRow = nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.slotsInRow");
        data.backpackUpgrades.feedingUpgradeSettings.tickRate = nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.tickRate");

        data.backpackUpgrades.refillUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.refillUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.refillUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.refillUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.refillUpgradeSettings.slotsInRow = nbt.method_10550("backpackUpgrades.refillUpgradeSettings.slotsInRow");
        data.backpackUpgrades.refillUpgradeSettings.tickRate = nbt.method_10550("backpackUpgrades.refillUpgradeSettings.tickRate");

        data.backpackUpgrades.voidUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.voidUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.voidUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.voidUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.voidUpgradeSettings.slotsInRow = nbt.method_10550("backpackUpgrades.voidUpgradeSettings.slotsInRow");

        //Leather
        data.backpackSettings.leather.inventorySlotCount = nbt.method_10550("backpackSettings.leather.inventorySlotCount");
        data.backpackSettings.leather.upgradeSlotCount = nbt.method_10550("backpackSettings.leather.upgradeSlotCount");
        data.backpackSettings.leather.toolSlotCount = nbt.method_10550("backpackSettings.leather.toolSlotCount");
        data.backpackSettings.leather.tankCapacityPerRow = nbt.method_10537("backpackSettings.leather.tankCapacityPerRow");
        //Iron
        data.backpackSettings.iron.inventorySlotCount = nbt.method_10550("backpackSettings.iron.inventorySlotCount");
        data.backpackSettings.iron.upgradeSlotCount = nbt.method_10550("backpackSettings.iron.upgradeSlotCount");
        data.backpackSettings.iron.toolSlotCount = nbt.method_10550("backpackSettings.iron.toolSlotCount");
        data.backpackSettings.iron.tankCapacityPerRow = nbt.method_10537("backpackSettings.iron.tankCapacityPerRow");
        //Gold
        data.backpackSettings.gold.inventorySlotCount = nbt.method_10550("backpackSettings.gold.inventorySlotCount");
        data.backpackSettings.gold.upgradeSlotCount = nbt.method_10550("backpackSettings.gold.upgradeSlotCount");
        data.backpackSettings.gold.toolSlotCount = nbt.method_10550("backpackSettings.gold.toolSlotCount");
        data.backpackSettings.gold.tankCapacityPerRow = nbt.method_10537("backpackSettings.gold.tankCapacityPerRow");
        //Diamond
        data.backpackSettings.diamond.inventorySlotCount = nbt.method_10550("backpackSettings.diamond.inventorySlotCount");
        data.backpackSettings.diamond.upgradeSlotCount = nbt.method_10550("backpackSettings.diamond.upgradeSlotCount");
        data.backpackSettings.diamond.toolSlotCount = nbt.method_10550("backpackSettings.diamond.toolSlotCount");
        data.backpackSettings.diamond.tankCapacityPerRow = nbt.method_10537("backpackSettings.diamond.tankCapacityPerRow");
        //Netherite
        data.backpackSettings.netherite.inventorySlotCount = nbt.method_10550("backpackSettings.netherite.inventorySlotCount");
        data.backpackSettings.netherite.upgradeSlotCount = nbt.method_10550("backpackSettings.netherite.upgradeSlotCount");
        data.backpackSettings.netherite.toolSlotCount = nbt.method_10550("backpackSettings.netherite.toolSlotCount");
        data.backpackSettings.netherite.tankCapacityPerRow = nbt.method_10537("backpackSettings.netherite.tankCapacityPerRow");

        data.backpackSettings.rightClickEquip = nbt.method_10577("backpackSettings.rightClickEquip");
        data.backpackSettings.rightClickUnequip = nbt.method_10577("backpackSettings.rightClickUnequip");
        data.backpackSettings.allowOnlyEquippedBackpack = nbt.method_10577("backpackSettings.allowOnlyEquippedBackpack");
        data.backpackSettings.allowOpeningFromSlot = nbt.method_10577("backpackSettings.allowOpeningFromSlot");
        data.backpackSettings.preventMultiplePlayersAccess = nbt.method_10577("backpackSettings.preventMultiplePlayersAccess");
        data.backpackSettings.invulnerableBackpack = nbt.method_10577("backpackSettings.invulnerableBackpack");
        data.backpackSettings.toolSlotsAcceptableItems = nbt.method_10558("backpackSettings.toolSlotsAcceptableItems").split(",");
        data.backpackSettings.blacklistedItems = nbt.method_10558("backpackSettings.blacklistedItems").split(",");
        data.backpackSettings.toolSlotsAcceptEverything = nbt.method_10577("backpackSettings.toolSlotsAcceptEverything");
        data.backpackSettings.allowShulkerBoxes = nbt.method_10577("backpackSettings.allowShulkerBoxes");
        data.backpackSettings.voidProtection = nbt.method_10577("backpackSettings.voidProtection");
        data.backpackSettings.backpackDeathPlace = nbt.method_10577("backpackSettings.backpackDeathPlace");
        data.backpackSettings.backpackForceDeathPlace = nbt.method_10577("backpackSettings.backpackForceDeathPlace");
        data.backpackSettings.quickSleepingBag = nbt.method_10577("backpackSettings.quickSleepingBag");
        data.backpackSettings.enableSleepingBagSpawnPoint = nbt.method_10577("backpackSettings.enableSleepingBagSpawnPoint");
        data.backpackSettings.backSlotIntegration = nbt.method_10577("backpackSettings.backSlotIntegration");

        //World
        data.world.enableLoot = nbt.method_10577("world.enableLoot");
        data.world.chance = nbt.method_10583("world.chance");
        data.world.spawnEntitiesWithBackpack = nbt.method_10577("world.spawnEntitiesWithBackpack");
        data.world.possibleOverworldEntityTypes = nbt.method_10558("world.possibleOverworldEntityTypes").split(",");
        data.world.possibleNetherEntityTypes = nbt.method_10558("world.possibleNetherEntityTypes").split(",");
        data.world.overworldBackpacks = nbt.method_10558("world.overworldBackpacks").split(",");
        data.world.netherBackpacks = nbt.method_10558("world.netherBackpacks").split(",");
        data.world.enableVillagerTrade = nbt.method_10577("world.enableVillagerTrade");

        //Backpack Abilities
        data.backpackAbilities.enableBackpackAbilities = nbt.method_10577("backpackAbilities.enableBackpackAbilities");
        data.backpackAbilities.forceAbilityEnabled = nbt.method_10577("backpackAbilities.forceAbilityEnabled");
        data.backpackAbilities.allowedAbilities = nbt.method_10558("backpackAbilities.allowedAbilities").split(",");
        data.backpackAbilities.backpackEffects = nbt.method_10558("backpackAbilities.backpackEffects").split(",");
        data.backpackAbilities.cooldowns = nbt.method_10558("backpackAbilities.cooldowns").split(",");

        //Slowness Debuff
        data.slownessDebuff.tooManyBackpacksSlowness = nbt.method_10577("slownessDebuff.tooManyBackpacksSlowness");
        data.slownessDebuff.maxNumberOfBackpacks = nbt.method_10550("slownessDebuff.maxNumberOfBackpacks");
        data.slownessDebuff.slownessPerExcessedBackpack = nbt.method_10550("slownessDebuff.slownessPerExcessedBackpack");
        return data;
    }

    public static void loadItemsFromConfig(String[] configList, List<class_1792> targetList) {
        for(String registryName : configList) {
            class_2960 res = class_2960.method_12829(registryName);

            if(class_7923.field_41178.method_10250(res)) {
                targetList.add(class_7923.field_41178.method_10223(res));
            }
        }
    }

    public static void loadBackpackEffectsFromConfig(String[] configList, Multimap<class_1792, BackpackEffect> backpackEffects) {
        try {
            for(String entry : configList) {
                String[] parts = entry.replace(" ", "").split(";");
                if(parts.length == 5) {
                    class_2960 backpackRes = class_2960.method_12829(parts[0]);
                    class_2960 effectRes = class_2960.method_12829(parts[1]);

                    if(class_7923.field_41178.method_10250(backpackRes) && class_7923.field_41174.method_55841(effectRes).isPresent()) {
                        class_1792 backpack = class_7923.field_41178.method_10223(backpackRes);
                        int minDuration = Integer.parseInt(parts[2]);
                        int maxDuration = Integer.parseInt(parts[3]);
                        int amplifier = Integer.parseInt(parts[4]);

                        if(minDuration < 0 || maxDuration < 0 || amplifier < 0) {
                            TravelersBackpack.LOGGER.error("Backpack Effects: duration and amplifier must be positive integers!");
                        }

                        if(minDuration > maxDuration) {
                            TravelersBackpack.LOGGER.error("Backpack Effects: minDuration must be less than or equal to maxDuration!");
                        }

                        backpackEffects.put(backpack, new BackpackEffect(class_7923.field_41174.method_55841(effectRes).get(), minDuration, maxDuration, amplifier));
                    }
                }
            }
        } catch(Exception e) {
            TravelersBackpack.LOGGER.error("Could not load Backpack Effect from Config! Check your config if entries are correct!");
        }
    }

    public static void loadCooldownsFromConfig(String[] config, Map<class_1792, Cooldown> cooldownConfigs) {
        try {
            for(String entry : config) {
                String[] parts = entry.replace(" ", "").split(";");
                if(parts.length == 3) {
                    class_2960 backpackRes = class_2960.method_12829(parts[0]);
                    class_1792 backpack = class_7923.field_41178.method_10223(backpackRes);
                    int minCooldown = Integer.parseInt(parts[1]);
                    int maxCooldown = Integer.parseInt(parts[2]);

                    if(minCooldown < 0 || maxCooldown < 0) {
                        TravelersBackpack.LOGGER.error("Cooldowns: cooldowns must be positive integers!");
                    }

                    if(minCooldown > maxCooldown) {
                        TravelersBackpack.LOGGER.error("Cooldowns: minCooldown must be less than or equal to maxCooldown!");
                    }

                    cooldownConfigs.put(backpack, new Cooldown(minCooldown, maxCooldown));
                }
            }
        } catch(Exception e) {
            TravelersBackpack.LOGGER.error("Could not load Cooldowns from Config! Check your config if entries are correct!");
        }
    }
}