package com.tiviacz.travelersbackpack.datagen;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.recipes.BackpackUpgradeRecipeBuilder;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipeBuilder;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8074;
import net.minecraft.class_8790;
import net.minecraft.data.recipes.*;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ModRecipeProvider extends FabricRecipeProvider {
    public ModRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> holderProvider) {
        super(output, holderProvider);
    }

    @Override
    public void method_10419(class_8790 writer) {
        //Smithing
        for(class_1792 item : BACKPACKS) {
            BackpackUpgradeRecipeBuilder.backpackUpgrade(class_1856.method_8106(ConventionalItemTags.LEATHERS), class_1856.method_8091(item), class_1856.method_8106(ModTags.BACKPACK_UPGRADES), class_7800.field_40642, item).unlocks(method_32807(item), method_10426(item)).save(writer, id(method_33716(item) + "_smithing"));
        }

        //Upgrades
        class_2447.method_10436(class_7800.field_40642, ModItems.BLANK_UPGRADE, 4)
                .method_10433('A', ConventionalItemTags.LEATHERS).method_10433('B', ConventionalItemTags.STRINGS)
                .method_10439(" B ").method_10439("BAB").method_10439(" B ")
                .method_10429("has_leather", method_10420(ConventionalItemTags.LEATHERS)).method_10431(writer);

        createFullGrid(ModItems.IRON_TIER_UPGRADE, class_1856.method_8091(ModItems.BLANK_UPGRADE),
                class_1856.method_8106(ConventionalItemTags.IRON_INGOTS), class_1802.field_8620, ConventionalItemTags.IRON_INGOTS).method_10431(writer);
        createFullGrid(ModItems.GOLD_TIER_UPGRADE, class_1856.method_8091(ModItems.BLANK_UPGRADE),
                class_1856.method_8106(ConventionalItemTags.GOLD_INGOTS), class_1802.field_8695, ConventionalItemTags.GOLD_INGOTS).method_10431(writer);
        createFullGrid(ModItems.DIAMOND_TIER_UPGRADE, class_1856.method_8091(ModItems.BLANK_UPGRADE),
                class_1856.method_8106(ConventionalItemTags.DIAMOND_GEMS), class_1802.field_8477, ConventionalItemTags.DIAMOND_GEMS).method_10431(writer);

        class_8074.method_48535(class_1856.method_8091(class_1802.field_41946), class_1856.method_8091(ModItems.BLANK_UPGRADE),
                        class_1856.method_8106(ConventionalItemTags.NETHERITE_INGOTS), class_7800.field_40642, ModItems.NETHERITE_TIER_UPGRADE)
                .method_48536(method_32807(class_1802.field_22020), method_10420(ConventionalItemTags.NETHERITE_INGOTS))
                .method_48537(writer, id("netherite_tier_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.TANKS_UPGRADE).method_10434('A', ModItems.BACKPACK_TANK)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10439("ABA")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("tanks_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.CRAFTING_UPGRADE).method_10433('A', ConventionalItemTags.PLAYER_WORKSTATIONS_CRAFTING_TABLES)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.WOODEN_CHESTS).method_10439("A").method_10439("B").method_10439("C")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("crafting_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.FURNACE_UPGRADE).method_10434('A', class_2246.field_10181)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.CHESTS).method_10439("A").method_10439("B").method_10439("C")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("furnace_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.SMOKER_UPGRADE).method_10434('A', class_2246.field_16334)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.CHESTS).method_10439("A").method_10439("B").method_10439("C")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("smoker_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.BLAST_FURNACE_UPGRADE).method_10434('A', class_2246.field_16333)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.CHESTS).method_10439("A").method_10439("B").method_10439("C")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("blast_furnace_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.FEEDING_UPGRADE).method_10434('A', class_1802.field_8071)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10434('C', class_1802.field_8463).method_10433('D', ConventionalItemTags.REDSTONE_DUSTS).method_10439("ABC").method_10439("DDD")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("feeding_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.PICKUP_UPGRADE).method_10434('A', class_1802.field_8239)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.REDSTONE_DUSTS).method_10439("ABA").method_10439("CCC")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("pickup_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.JUKEBOX_UPGRADE).method_10433('A', ConventionalItemTags.REDSTONE_DUSTS)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10434('C', class_1802.field_8565).method_10439(" B ").method_10439("ACA")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("jukebox_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.REFILL_UPGRADE).method_10434('A', class_1802.field_8878)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.REDSTONE_DUSTS).method_10439("ABA").method_10439("CCC")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("refill_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.MAGNET_UPGRADE).method_10433('A', ConventionalItemTags.ENDER_PEARLS)
                .method_10433('B', ConventionalItemTags.REDSTONE_DUSTS).method_10434('C', ModItems.BLANK_UPGRADE)
                .method_10433('D', ConventionalItemTags.LAPIS_GEMS).method_10433('E', ConventionalItemTags.IRON_INGOTS).method_10439("A A").method_10439("BCD").method_10439("BED")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("magnet_upgrade"));

        class_2447.method_10437(class_7800.field_40642, ModItems.VOID_UPGRADE).method_10434('A', class_1802.field_8187)
                .method_10434('B', ModItems.BLANK_UPGRADE).method_10433('C', ConventionalItemTags.REDSTONE_DUSTS).method_10439("ABA").method_10439("CCC")
                .method_10429(method_32807(ModItems.BLANK_UPGRADE), method_10426(ModItems.BLANK_UPGRADE)).method_17972(writer, id("void_upgrade"));

        //All Recipes
        class_2447.method_10437(class_7800.field_40642, ModItems.BACKPACK_TANK)
                .method_10433('B', ConventionalItemTags.GLASS_BLOCKS_COLORLESS).method_10433('A', ConventionalItemTags.IRON_INGOTS)
                .method_10439("BAB").method_10439("B B").method_10439("BAB")
                .method_10429("has_iron", method_10420(ConventionalItemTags.IRON_INGOTS)).method_17972(writer, id("backpack_tank"));

        class_2447.method_10437(class_7800.field_40642, ModItems.HOSE_NOZZLE)
                .method_10433('A', ConventionalItemTags.GOLD_INGOTS).method_10433('B', ConventionalItemTags.IRON_INGOTS)
                .method_10439(" A ").method_10439("B B")
                .method_10429("has_iron", method_10420(ConventionalItemTags.IRON_INGOTS)).method_17972(writer, id("hose_nozzle"));

        class_2447.method_10437(class_7800.field_40638, ModItems.HOSE)
                .method_10434('A', ModItems.HOSE_NOZZLE).method_10433('B', ConventionalItemTags.GREEN_DYES)
                .method_10439("ABB").method_10439("  B").method_10439("  B")
                .method_10429(method_32807(ModItems.HOSE_NOZZLE), method_10426(ModItems.HOSE_NOZZLE)).method_17972(writer, id("hose"));

        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.STANDARD_TRAVELERS_BACKPACK).method_33529("standard_travelers_backpack")
                .define('X', ConventionalItemTags.LEATHERS).define('B', ConventionalItemTags.STRINGS).define('C', ModItems.BACKPACK_TANK)
                .define('D', ConventionalItemTags.WOODEN_CHESTS).define('S', ModTags.SLEEPING_BAGS)
                .pattern("XBX").pattern("CDC").pattern("XSX")
                .method_33530("has_chest", method_10420(ConventionalItemTags.WOODEN_CHESTS)).method_17972(writer, id("standard"));

        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.STANDARD_TRAVELERS_BACKPACK).method_33529("standard_travelers_backpack")
                .define('X', ConventionalItemTags.LEATHERS).define('B', ConventionalItemTags.STRINGS)
                .define('D', ConventionalItemTags.WOODEN_CHESTS).define('S', ModTags.SLEEPING_BAGS)
                .pattern("XBX").pattern(" D ").pattern("XSX")
                .method_33530("has_chest", method_10420(ConventionalItemTags.WOODEN_CHESTS)).method_17972(writer, id("standard_no_tanks"));

        //Netherite backpack
        class_8074.method_48535(class_1856.method_8091(class_1802.field_41946),
                        class_1856.method_8091(ModItems.DIAMOND_TRAVELERS_BACKPACK), class_1856.method_8106(ConventionalItemTags.NETHERITE_INGOTS),
                        class_7800.field_40642, ModItems.NETHERITE_TRAVELERS_BACKPACK)
                .method_48536(method_32807(class_1802.field_22020), method_10420(ConventionalItemTags.NETHERITE_INGOTS)).method_48537(writer, id("netherite"));

        createBackpackSmallGrid(ModItems.DIAMOND_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.DIAMOND_GEMS), method_32807(class_1802.field_8477), method_10420(ConventionalItemTags.DIAMOND_GEMS)).method_10431(writer);
        createBackpackSmallGrid(ModItems.GOLD_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.GOLD_INGOTS), method_32807(class_1802.field_8695), method_10420(ConventionalItemTags.GOLD_INGOTS)).method_10431(writer);
        createBackpackSmallGrid(ModItems.EMERALD_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.EMERALD_GEMS), method_32807(class_1802.field_8687), method_10420(ConventionalItemTags.EMERALD_GEMS)).method_10431(writer);
        createBackpackSmallGrid(ModItems.IRON_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.IRON_INGOTS), method_32807(class_1802.field_8620), method_10420(ConventionalItemTags.IRON_INGOTS)).method_10431(writer);

        createBackpackSmallGrid(ModItems.ENDERMAN_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.ENDER_PEARLS), method_32807(class_1802.field_8634), method_10420(ConventionalItemTags.ENDER_PEARLS)).method_10431(writer);
        createBackpackSmallGrid(ModItems.WOLF_TRAVELERS_BACKPACK, class_1856.method_8091(class_1802.field_8606), method_32807(class_1802.field_8606), method_10426(class_1802.field_8606)).method_10431(writer);
        createBackpackSmallGrid(ModItems.FOX_TRAVELERS_BACKPACK, class_1856.method_8091(class_1802.field_16998), method_32807(class_1802.field_16998), method_10426(class_1802.field_16998)).method_10431(writer);
        createBackpackSmallGrid(ModItems.OCELOT_TRAVELERS_BACKPACK, class_1856.method_8091(class_1802.field_8429), method_32807(class_1802.field_8429), method_10426(class_1802.field_8429)).method_10431(writer);
        //createBackpackSmallGrid(ModItems.SQUID_TRAVELERS_BACKPACK, Ingredient.of(Items.INK_SAC), getHasName(Items.INK_SAC), has(Items.INK_SAC)).save(writer);

        createBackpackFullGrid(ModItems.REDSTONE_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.REDSTONE_DUSTS), method_32807(class_1802.field_8725), method_10420(ConventionalItemTags.REDSTONE_DUSTS)).method_10431(writer);
        createBackpackFullGrid(ModItems.COAL_TRAVELERS_BACKPACK, class_1856.method_8106(class_3489.field_17487), method_32807(class_1802.field_8713), method_10420(class_3489.field_17487)).method_10431(writer);
        createBackpackFullGrid(ModItems.SPONGE_TRAVELERS_BACKPACK, class_1856.method_8091(class_1802.field_8535), method_32807(class_1802.field_8535), method_10426(class_1802.field_8535)).method_10431(writer);
        createBackpackFullGrid(ModItems.HAY_TRAVELERS_BACKPACK, class_1856.method_8106(ConventionalItemTags.WHEAT_CROPS), method_32807(class_1802.field_8861), method_10420(ConventionalItemTags.WHEAT_CROPS)).method_10431(writer);

        //Bee
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.BEE_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_20414).define('B', class_1802.field_20417).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_20414), method_10426(class_1802.field_20414)).method_33530(method_32807(class_1802.field_20417), method_10426(class_1802.field_20417)).method_10431(writer);

        //Blaze
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.BLAZE_TRAVELERS_BACKPACK)
                .define('A', ConventionalItemTags.BLAZE_RODS).define('B', class_1802.field_8814)
                .define('C', ModItems.STANDARD_TRAVELERS_BACKPACK).define('D', class_1802.field_8183).define('E', class_1802.field_8187)
                .pattern("ABA").pattern("ACA").pattern("DED")
                .method_33530(method_32807(class_1802.field_8894), method_10420(ConventionalItemTags.BLAZE_RODS)).method_10431(writer);

        //Bookshelf
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.BOOKSHELF_TRAVELERS_BACKPACK)
                .define('A', class_3489.field_15537).define('B', class_1802.field_8529).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("AAA").pattern("BCB").pattern("AAA")
                .method_33530(method_32807(class_1802.field_8529), method_10426(class_1802.field_8529)).method_10431(writer);

        //Cactus
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.CACTUS_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_17520).define('B', ConventionalItemTags.GREEN_DYES)
                .define('C', ModItems.STANDARD_TRAVELERS_BACKPACK).define('D', class_1802.field_8858)
                .pattern("ABA").pattern("ACA").pattern("DDD")
                .method_33530(method_32807(class_1802.field_17520), method_10426(class_1802.field_17520)).method_10431(writer);

        //Cake
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.CAKE_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8103).define('B', class_1802.field_8803).define('C', class_1802.field_8479)
                .define('D', ModItems.STANDARD_TRAVELERS_BACKPACK).define('E', ConventionalItemTags.WHEAT_CROPS)
                .pattern("ABA").pattern("CDC").pattern("EEE")
                .method_33530(method_32807(class_1802.field_8803), method_10426(class_1802.field_8803)).method_10431(writer);

        //Chicken
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.CHICKEN_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8153).define('B', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .define('C', class_1802.field_8803).pattern(" A ").pattern("ABA").pattern("CCC")
                .method_33530(method_32807(class_1802.field_8153), method_10426(class_1802.field_8153)).method_10431(writer);

        //Cow
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.COW_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8046).define('B', ConventionalItemTags.LEATHERS).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK).define('D', class_1802.field_8103)
                .pattern("ABA").pattern("ACA").pattern("BDB")
                .method_33530(method_32807(class_1802.field_8103), method_10426(class_1802.field_8103)).method_10431(writer);

        //Creeper
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.CREEPER_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8054).define('B', class_1802.field_8681).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .define('D', class_1802.field_8626).pattern("ABA").pattern("ACA").pattern("DDD")
                .method_33530(method_32807(class_1802.field_8054), method_10426(class_1802.field_8054)).method_10431(writer);

        //Dragon
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.DRAGON_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8613).define('B', class_1802.field_8712).define('C', class_1802.field_20399)
                .define('D', ModItems.STANDARD_TRAVELERS_BACKPACK).define('E', ConventionalItemTags.ENDER_PEARLS)
                .pattern("ABA").pattern("CDC").pattern("ECE")
                .method_33530(method_32807(class_1802.field_8613), method_10426(class_1802.field_8613)).method_10431(writer);

        //End
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.END_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8449).define('B', class_1802.field_20399).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_8449), method_10426(class_1802.field_8449)).method_10431(writer);

        //Ghast
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.GHAST_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8070).define('B', class_1802.field_8814).define('C', class_1802.field_8054)
                .define('D', ModItems.STANDARD_TRAVELERS_BACKPACK).pattern("ABA").pattern("CDC").pattern("ACA")
                .method_33530(method_32807(class_1802.field_8070), method_10426(class_1802.field_8070)).method_10431(writer);

        //Horse
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.HORSE_TRAVELERS_BACKPACK)
                .define('A', ConventionalItemTags.LEATHERS).define('B', class_1802.field_8279).define('C', ConventionalItemTags.WHEAT_CROPS).define('D', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("CDC").pattern("ACA")
                .method_33530(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745)).method_10431(writer);

        //Lapis
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.LAPIS_TRAVELERS_BACKPACK)
                .define('A', ConventionalItemTags.STORAGE_BLOCKS_LAPIS).define('B', ConventionalItemTags.LAPIS_GEMS).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_8759), method_10420(ConventionalItemTags.LAPIS_GEMS)).method_10431(writer);

        //Magma Cube
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8135).define('B', class_1802.field_8187).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("ACA").pattern("ABA")
                .method_33530(method_32807(class_1802.field_8135), method_10426(class_1802.field_8135)).method_10431(writer);

        //Melon
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.MELON_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8497).define('B', ModItems.STANDARD_TRAVELERS_BACKPACK).define('C', class_1802.field_46250)
                .pattern("A A").pattern("ABA").pattern("ACA")
                .method_33530(method_32807(class_1802.field_8497), method_10426(class_1802.field_8497)).method_10431(writer);

        //Nether
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.NETHER_TRAVELERS_BACKPACK)
                .define('A', ConventionalItemTags.QUARTZ_GEMS).define('B', ConventionalItemTags.NETHER_WART_CROPS).define('C', class_1802.field_8328)
                .define('D', ModItems.STANDARD_TRAVELERS_BACKPACK).define('E', class_1802.field_23843).define('F', class_1802.field_8187)
                .pattern("ABA").pattern("CDC").pattern("EFE")
                .method_33530(method_32807(class_1802.field_8790), method_10420(ConventionalItemTags.NETHER_WART_CROPS)).method_10431(writer);

        //Pig
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.PIG_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8389).define('B', ConventionalItemTags.CARROT_CROPS).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("ACA").pattern("AAA")
                .method_33530(method_32807(class_1802.field_8389), method_10426(class_1802.field_8389)).method_10431(writer);

        //Pumpkin
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.PUMPKIN_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_17518).define('B', class_1802.field_17519).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK).define('D', class_1802.field_46249)
                .pattern("ABA").pattern("ACA").pattern("ADA")
                .method_33530(method_32807(class_1802.field_17518), method_10426(class_1802.field_17518)).method_10431(writer);

        //Quartz
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.QUARTZ_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_20402).define('B', ConventionalItemTags.QUARTZ_GEMS).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_8155), method_10420(ConventionalItemTags.QUARTZ_GEMS)).method_10431(writer);

        //Sandstone
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.SANDSTONE_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_20384).define('B', class_1802.field_8552).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("ACA").pattern("AAA")
                .method_33530(method_32807(class_1802.field_20384), method_10426(class_1802.field_20384)).method_10431(writer);

        //Sheep
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.SHEEP_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_19044).define('B', class_1802.field_8748).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_19044), method_10426(class_1802.field_19044)).method_10431(writer);

        //Skeleton
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.SKELETON_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8606).define('B', class_1802.field_8107).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK).define('D', class_1802.field_8102)
                .pattern("ABA").pattern("BCB").pattern("ADA")
                .method_33530(method_32807(class_1802.field_8107), method_10426(class_1802.field_8107)).method_10431(writer);

        //Snow
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.SNOW_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8426).define('B', class_1802.field_8246).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK).define('D', class_1802.field_8543)
                .pattern("AAA").pattern("BCB").pattern("DBD")
                .method_33530(method_32807(class_1802.field_8543), method_10426(class_1802.field_8543)).method_10431(writer);

        //Spider
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.SPIDER_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8680).define('B', class_1802.field_8276).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_8276), method_10426(class_1802.field_8276)).method_10431(writer);

        //Squid
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.SQUID_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_28410).define('B', class_1802.field_8794).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("ABA").pattern("BCB").pattern("ABA")
                .method_33530(method_32807(class_1802.field_8794), method_10426(class_1802.field_8794)).method_10431(writer);

        //Wither
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.WITHER_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_8791).define('B', class_1802.field_8067).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("AAA").pattern("BCB").pattern(" B ")
                .method_33530(method_32807(class_1802.field_8791), method_10426(class_1802.field_8791)).method_10431(writer);

        //Warden
        ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, ModItems.WARDEN_TRAVELERS_BACKPACK)
                .define('A', class_1802.field_38746).define('B', class_1802.field_41951).define('C', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("AAA").pattern("ACA").pattern("ABA")
                .method_33530(method_32807(class_1802.field_38746), method_10426(class_1802.field_38746)).method_10431(writer);

        //Sleeping Bags
        sleepingBagFromWool(writer, ModItems.BLACK_SLEEPING_BAG, class_1802.field_19059);
        sleepingBagFromWool(writer, ModItems.BLUE_SLEEPING_BAG, class_1802.field_19055);
        sleepingBagFromWool(writer, ModItems.BROWN_SLEEPING_BAG, class_1802.field_19056);
        sleepingBagFromWool(writer, ModItems.CYAN_SLEEPING_BAG, class_1802.field_19053);
        sleepingBagFromWool(writer, ModItems.GRAY_SLEEPING_BAG, class_1802.field_19051);
        sleepingBagFromWool(writer, ModItems.GREEN_SLEEPING_BAG, class_1802.field_19057);
        sleepingBagFromWool(writer, ModItems.LIGHT_BLUE_SLEEPING_BAG, class_1802.field_19047);
        sleepingBagFromWool(writer, ModItems.LIGHT_GRAY_SLEEPING_BAG, class_1802.field_19052);
        sleepingBagFromWool(writer, ModItems.LIME_SLEEPING_BAG, class_1802.field_19049);
        sleepingBagFromWool(writer, ModItems.MAGENTA_SLEEPING_BAG, class_1802.field_19046);
        sleepingBagFromWool(writer, ModItems.ORANGE_SLEEPING_BAG, class_1802.field_19045);
        sleepingBagFromWool(writer, ModItems.PINK_SLEEPING_BAG, class_1802.field_19050);
        sleepingBagFromWool(writer, ModItems.PURPLE_SLEEPING_BAG, class_1802.field_19054);
        sleepingBagFromWool(writer, ModItems.RED_SLEEPING_BAG, class_1802.field_19058);
        sleepingBagFromWool(writer, ModItems.WHITE_SLEEPING_BAG, class_1802.field_19044);
        sleepingBagFromWool(writer, ModItems.YELLOW_SLEEPING_BAG, class_1802.field_19048);

        List<class_1792> list = List.of(class_1802.field_8226, class_1802.field_8345, class_1802.field_8099, class_1802.field_8632, class_1802.field_8298, class_1802.field_8408, class_1802.field_8273, class_1802.field_8851, class_1802.field_8131, class_1802.field_8669, class_1802.field_8492, class_1802.field_8330, class_1802.field_8296, class_1802.field_8264, class_1802.field_8192, class_1802.field_8446);
        List<class_1792> list2 = List.of(ModItems.BLACK_SLEEPING_BAG, ModItems.BLUE_SLEEPING_BAG, ModItems.BROWN_SLEEPING_BAG, ModItems.CYAN_SLEEPING_BAG, ModItems.GRAY_SLEEPING_BAG, ModItems.GREEN_SLEEPING_BAG, ModItems.LIGHT_BLUE_SLEEPING_BAG, ModItems.LIGHT_GRAY_SLEEPING_BAG, ModItems.LIME_SLEEPING_BAG, ModItems.MAGENTA_SLEEPING_BAG, ModItems.ORANGE_SLEEPING_BAG, ModItems.PINK_SLEEPING_BAG, ModItems.PURPLE_SLEEPING_BAG, ModItems.RED_SLEEPING_BAG, ModItems.YELLOW_SLEEPING_BAG, ModItems.WHITE_SLEEPING_BAG);
        method_51890(writer, list, list2, "sleeping_bag");
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655(TravelersBackpack.MODID, name);
    }

    protected static void sleepingBagFromWool(class_8790 recipeOutput, class_1935 sleepingBag, class_1935 pWool) {
        class_2447.method_10437(class_7800.field_40635, sleepingBag).method_10435("sleeping_bag").method_10434('#', pWool).method_10434('X', class_1802.field_19044).method_10439("##X").method_10429(method_32807(pWool), method_10426(pWool)).method_10431(recipeOutput);
    }

    public static void method_51890(class_8790 recipeOutput, List<class_1792> pDyes, List<class_1792> pDyeableItems, String pGroup) {
        for(int i = 0; i < pDyes.size(); ++i) {
            class_1792 item = pDyes.get(i);
            class_1792 item1 = pDyeableItems.get(i);
            class_2450.method_10447(class_7800.field_40634, item1)
                    .method_10454(item).method_10451(class_1856.method_26964(pDyeableItems.stream().filter((p_288265_) -> !p_288265_.equals(item1))
                            .map(class_1799::new))).method_10452(pGroup).method_10442("has_needed_dye", method_10426(item))
                    .method_17972(recipeOutput, id("dye_" + method_33716(item1)));
        }
    }

    public ShapedBackpackRecipeBuilder createBackpackSmallGrid(class_1792 result, class_1856 ingredient, String criterionName, class_175<?> criterion) {
        return ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, result)
                .define('A', ingredient).define('B', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern(" A ").pattern("ABA").pattern(" A ").method_33530(criterionName, criterion);
    }

    public ShapedBackpackRecipeBuilder createBackpackFullGrid(class_1792 result, class_1856 ingredient, String criterionName, class_175<?> criterion) {
        return ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, result)
                .define('A', ingredient).define('B', ModItems.STANDARD_TRAVELERS_BACKPACK)
                .pattern("AAA").pattern("ABA").pattern("AAA").method_33530(criterionName, criterion);
    }

    public ShapedBackpackRecipeBuilder createFullGrid(class_1792 result, class_1856 ingredient, class_1856 ingredient1, class_1792 unlocker, class_6862<class_1792> tag) {
        return ShapedBackpackRecipeBuilder.shaped(class_7800.field_40642, result)
                .define('A', ingredient1).define('B', ingredient)
                .pattern("AAA").pattern("ABA").pattern("AAA").method_33530(method_32807(unlocker), method_10420(tag));
    }

    public static final class_1792[] BACKPACKS = {
            ModItems.STANDARD_TRAVELERS_BACKPACK,
            ModItems.NETHERITE_TRAVELERS_BACKPACK,
            ModItems.DIAMOND_TRAVELERS_BACKPACK,
            ModItems.GOLD_TRAVELERS_BACKPACK,
            ModItems.EMERALD_TRAVELERS_BACKPACK,
            ModItems.IRON_TRAVELERS_BACKPACK,
            ModItems.LAPIS_TRAVELERS_BACKPACK,
            ModItems.REDSTONE_TRAVELERS_BACKPACK,
            ModItems.COAL_TRAVELERS_BACKPACK,

            ModItems.QUARTZ_TRAVELERS_BACKPACK,
            ModItems.BOOKSHELF_TRAVELERS_BACKPACK,
            ModItems.END_TRAVELERS_BACKPACK,
            ModItems.NETHER_TRAVELERS_BACKPACK,
            ModItems.SANDSTONE_TRAVELERS_BACKPACK,
            ModItems.SNOW_TRAVELERS_BACKPACK,
            ModItems.SPONGE_TRAVELERS_BACKPACK,

            ModItems.CAKE_TRAVELERS_BACKPACK,

            ModItems.CACTUS_TRAVELERS_BACKPACK,
            ModItems.HAY_TRAVELERS_BACKPACK,
            ModItems.MELON_TRAVELERS_BACKPACK,
            ModItems.PUMPKIN_TRAVELERS_BACKPACK,

            ModItems.CREEPER_TRAVELERS_BACKPACK,
            ModItems.DRAGON_TRAVELERS_BACKPACK,
            ModItems.ENDERMAN_TRAVELERS_BACKPACK,
            ModItems.BLAZE_TRAVELERS_BACKPACK,
            ModItems.GHAST_TRAVELERS_BACKPACK,
            ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK,
            ModItems.SKELETON_TRAVELERS_BACKPACK,
            ModItems.SPIDER_TRAVELERS_BACKPACK,
            ModItems.WITHER_TRAVELERS_BACKPACK,
            ModItems.WARDEN_TRAVELERS_BACKPACK,

            ModItems.BAT_TRAVELERS_BACKPACK,
            ModItems.BEE_TRAVELERS_BACKPACK,
            ModItems.WOLF_TRAVELERS_BACKPACK,
            ModItems.FOX_TRAVELERS_BACKPACK,
            ModItems.OCELOT_TRAVELERS_BACKPACK,
            ModItems.HORSE_TRAVELERS_BACKPACK,
            ModItems.COW_TRAVELERS_BACKPACK,
            ModItems.PIG_TRAVELERS_BACKPACK,
            ModItems.SHEEP_TRAVELERS_BACKPACK,
            ModItems.CHICKEN_TRAVELERS_BACKPACK,
            ModItems.SQUID_TRAVELERS_BACKPACK,
            ModItems.VILLAGER_TRAVELERS_BACKPACK,
            ModItems.IRON_GOLEM_TRAVELERS_BACKPACK,
    };
}