package com.tiviacz.travelersbackpack.fluids.effects;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3611;
import net.minecraft.class_9334;

public class PotionEffect extends EffectFluid {
    public PotionEffect(String uniqueId, class_3611 fluid) {
        super(uniqueId, fluid, FluidConstants.BOTTLE);
    }

    public PotionEffect(String uniqueId, String modid, String fluidName) {
        super(uniqueId, modid, fluidName, FluidConstants.BOTTLE);
    }

    @Override
    public void affectDrinker(FluidVariantWrapper stack, class_1937 level, class_1297 entity) {
        if(!level.field_9236 && entity instanceof class_1657 player) {
            for(class_1293 mobEffectInstance : stack.fluidVariant().getComponents().method_57845(class_9334.field_49651).get().method_57397()) {
                if(mobEffectInstance.method_5579().comp_349().method_5561()) {
                    mobEffectInstance.method_5579().comp_349().method_5564(player, player, player, mobEffectInstance.method_5578(), 1.0D);
                } else {
                    player.method_6092(new class_1293(mobEffectInstance));
                }
            }
        }
    }

    @Override
    public boolean canExecuteEffect(FluidVariantWrapper stack, class_1937 level, class_1297 entity) {
        return stack.getAmount() >= amountRequired;
    }
}