package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.advancements.ActionTypeTrigger;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_5556;
import net.minecraft.class_5712;
import net.minecraft.class_9334;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class RightClickHandler {


    public static void registerListeners() {
        UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> {

            class_2338 pos = hitResult.method_17777();

            //Quick Unequip
            if(TravelersBackpackConfig.getConfig().backpackSettings.rightClickUnequip && !TravelersBackpack.enableIntegration()) {
                if(ComponentUtils.isWearingBackpack(player) && !level.field_9236) {
                    if(player.method_5715() && hand == class_1268.field_5808 && player.method_6047().method_7960()) {
                        class_1799 backpackStack = ComponentUtils.getWearingBackpack(player).method_7972();
                        class_1838 context = new class_1838(level, player, hand, backpackStack, hitResult);
                        boolean quickPickupFlag = level.method_8320(pos).method_26204() instanceof TravelersBackpackBlock;

                        if(!quickPickupFlag && backpackStack.method_7909() instanceof TravelersBackpackItem item) {
                            if(item.method_7712(new class_1750(context)) == class_1269.method_29236(level.field_9236)) {
                                player.method_23667(hand, true);
                                level.method_8396(null, player.method_24515(), class_3417.field_14581.comp_349(), class_3419.field_15248, 1.05F, (1.0F + (level.method_8409().method_43057() - level.method_8409().method_43057()) * 0.2F) * 0.7F);
                                ComponentUtils.getComponent(player).ifPresent(data -> {
                                    data.remove();
                                    data.synchronise();
                                });
                                return class_1269.field_5812;
                                //event.setCanceled(true);
                                //event.setCancellationResult(InteractionResult.SUCCESS);
                                //return;
                            }
                        }
                    }
                }
            }

            //Change Sleeping Bag
            if(player.method_5715() && hand == class_1268.field_5808 && player.method_6047().method_31573(ModTags.SLEEPING_BAGS) && level.method_8321(pos) instanceof BackpackBlockEntity blockEntity) {
                class_1799 oldSleepingBag = blockEntity.getProperSleepingBag(blockEntity.getWrapper().getSleepingBagColor()).method_26204().method_8389().method_7854();
                blockEntity.getWrapper().setSleepingBagColor(ShapedBackpackRecipe.getProperColor(player.method_6047().method_7909()));

                if(!level.field_9236) {
                    if(player instanceof class_3222 serverPlayer) {
                        ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, ActionTypeTrigger.CHANGE_SLEEPING_BAG);
                    }
                    class_1264.method_5449(level, pos.method_10263(), pos.method_10084().method_10264(), pos.method_10260(), oldSleepingBag);
                    player.method_6047().method_7934(1);
                }
                level.method_8396(null, player.method_24515(), class_3417.field_14581.comp_349(), class_3419.field_15248, 1.0F, (1.0F + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.2F) * 0.7F);
                return class_1269.field_5812;
                //event.setCancellationResult(InteractionResult.SUCCESS);
                //event.setCanceled(true);
                //return;
            }

            //Remove custom backpack design (go back to standard)
            if(player.method_5715() && hand == class_1268.field_5808 && player.method_6047().method_31574(class_1802.field_8868) && level.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
                if(!backpackBlockEntity.getWrapper().getBackpackStack().method_31574(ModItems.STANDARD_TRAVELERS_BACKPACK)) {
                    class_1799 standardBackpack = new class_1799(ModItems.STANDARD_TRAVELERS_BACKPACK, 1);
                    backpackBlockEntity.toItemStack(standardBackpack);
                    class_2350 direction = level.method_8320(pos).method_11654(TravelersBackpackBlock.FACING);
                    if(!level.field_9236 && level.method_8501(pos, net.minecraft.class_2246.field_10124.method_9564())) {
                        if(player instanceof class_3222 serverPlayer) {
                            ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, ActionTypeTrigger.REVERT_CUSTOM_BACKPACK);
                        }
                        class_1264.method_5449(level, pos.method_10263(), pos.method_10264(), pos.method_10260(), standardBackpack);
                        backpackBlockEntity.removeSleepingBag(level, direction);
                        level.method_8396(null, backpackBlockEntity.method_11016(), class_3417.field_14975, class_3419.field_15248, 1.0F, 1.0F);
                        player.method_32875(class_5712.field_28730, player);
                        player.method_6047().method_7970(1, player, class_1309.method_56079(hand));
                    }
                    return class_1269.field_5812;
                    //event.setCancellationResult(InteractionResult.SUCCESS);
                    // event.setCanceled(true);
                    //return;
                }
            }

            if(player.method_5715() && player.method_6047().method_7909() == ModItems.BLANK_UPGRADE && level.method_8321(pos) instanceof BackpackBlockEntity blockEntity) {
                class_2371<class_1799> list = class_2371.method_10211();
                for(int i = 0; i < blockEntity.getWrapper().getStorage().getSlots(); i++) {
                    class_1799 stackInSlot = blockEntity.getWrapper().getStorage().getStackInSlot(i);
                    if(!stackInSlot.method_7960()) {
                        list.add(stackInSlot);
                    }
                }
                for(int i = 0; i < blockEntity.getWrapper().getTools().getSlots(); i++) {
                    class_1799 stackInSlot = blockEntity.getWrapper().getTools().getStackInSlot(i);
                    if(!stackInSlot.method_7960()) {
                        list.add(stackInSlot);
                    }
                }
                for(int i = 0; i < blockEntity.getWrapper().getUpgrades().getSlots(); i++) {
                    class_1799 stackInSlot = blockEntity.getWrapper().getUpgrades().getStackInSlot(i);
                    if(!stackInSlot.method_7960()) {
                        list.add(stackInSlot);
                    }
                }
                int tier = blockEntity.getWrapper().getBackpackStack().method_57825(ModDataComponents.TIER, 0);
                if(tier != 0) {
                    list.addAll(getUpgrades(tier));
                }

                //Add backpack
                class_1792 backpackItem = blockEntity.getWrapper().getBackpackStack().method_7909();
                list.add(backpackItem.method_7854());

                if(!level.field_9236) {
                    class_1264.method_17349(level, pos.method_10084(), list);
                    level.method_8501(pos, class_2246.field_10124.method_9564());
                }

                return class_1269.field_5812;
            }

            //Quick Equip
            if(TravelersBackpackConfig.getConfig().backpackSettings.rightClickEquip && level.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
                if(player.method_5715() && !ComponentUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
                    //Prioritize placing block
                    if(player.method_5998(hand).method_7909() instanceof class_1747) {
                        return class_1269.field_5811;
                    }
                    class_1799 backpack = new class_1799(level.method_8320(pos).method_26204(), 1).method_7972();
                    backpackBlockEntity.toItemStack(backpack);
                    class_2350 direction = level.method_8320(pos).method_11654(TravelersBackpackBlock.FACING);

                    if(!level.field_9236 && level.method_8501(pos, class_2246.field_10124.method_9564())) {
                        ComponentUtils.equipBackpack(player, backpack);
                        backpackBlockEntity.removeSleepingBag(level, direction);

                        return class_1269.field_5812;
                        //event.setCanceled(true);
                        //event.setCancellationResult(InteractionResult.SUCCESS);
                        //return;
                    }
                }
            }

            //Quick Pick-Up
            if(level.method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
                if(player.method_5715() && hand == class_1268.field_5808 && player.method_6047().method_7960()) {
                    class_1799 backpack = new class_1799(level.method_8320(pos).method_26204(), 1).method_7972();
                    backpackBlockEntity.toItemStack(backpack);
                    class_2350 direction = level.method_8320(pos).method_11654(TravelersBackpackBlock.FACING);

                    if(player.method_31548().field_7545 < 0 || player.method_31548().field_7545 > player.method_31548().field_7547.size()) {
                        return class_1269.field_5814; //Fix for Deselect
                    }
                    
                    if(!level.field_9236 && level.method_8501(pos, class_2246.field_10124.method_9564())) {
                        player.method_6122(class_1268.field_5808, backpack);
                        backpackBlockEntity.removeSleepingBag(level, direction);
                        level.method_8396(null, player.method_24515(), class_3417.field_14581.comp_349(), class_3419.field_15248, 1.0F, (1.0F + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.2F) * 0.7F);

                        return class_1269.field_5812;
                        //
                        // event.setCanceled(true);
                        //event.setCancellationResult(InteractionResult.SUCCESS);
                    }
                }
            }

            //Grant achievement for washing backpack
            if(level.method_8320(pos).method_26204() instanceof class_5556) {
                class_1799 stack = player.method_5998(hand);
                if(stack.method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK && stack.method_31573(class_3489.field_48803) && stack.method_57826(class_9334.field_49644)) {
                    if(player instanceof class_3222 serverPlayer) {
                        ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, ActionTypeTrigger.UNDYE_BACKPACK);
                    }
                }
            }

            return class_1269.field_5811;
        });
    }

    public static final List<Supplier<class_1792>> UPGRADES = Arrays.asList(
            () -> ModItems.IRON_TIER_UPGRADE,
            () -> ModItems.GOLD_TIER_UPGRADE,
            () -> ModItems.DIAMOND_TIER_UPGRADE,
            () -> ModItems.NETHERITE_TIER_UPGRADE);

    public static class_2371<class_1799> getUpgrades(int tier) {
        class_2371<class_1799> list = class_2371.method_10211();
        for(int i = 0; i < tier; i++) {
            list.add(UPGRADES.get(i).get().method_7854());
        }
        return list;
    }

    public static void initializeDefaultSize(class_1799 stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        stack.method_57379(ModDataComponents.TIER, tier.getOrdinal());
        stack.method_57379(ModDataComponents.STORAGE_SLOTS, tier.getStorageSlots());
        stack.method_57379(ModDataComponents.UPGRADE_SLOTS, tier.getUpgradeSlots());
        stack.method_57379(ModDataComponents.TOOL_SLOTS, tier.getToolSlots());
    }
}