package com.tiviacz.travelersbackpack.init;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.handler.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_7923;
import java.util.Iterator;

public class ModBlockEntityTypes {
    public static class_2591<BackpackBlockEntity> BACKPACK;

    public static void init() {
        BACKPACK = class_2378.method_10226(class_7923.field_41181, TravelersBackpack.MODID + ":travelers_backpack", FabricBlockEntityTypeBuilder.create(BackpackBlockEntity::new, ModBlocks.STANDARD_TRAVELERS_BACKPACK,
                ModBlocks.NETHERITE_TRAVELERS_BACKPACK,
                ModBlocks.DIAMOND_TRAVELERS_BACKPACK,
                ModBlocks.GOLD_TRAVELERS_BACKPACK,
                ModBlocks.EMERALD_TRAVELERS_BACKPACK,
                ModBlocks.IRON_TRAVELERS_BACKPACK,
                ModBlocks.LAPIS_TRAVELERS_BACKPACK,
                ModBlocks.REDSTONE_TRAVELERS_BACKPACK,
                ModBlocks.COAL_TRAVELERS_BACKPACK,

                ModBlocks.QUARTZ_TRAVELERS_BACKPACK,
                ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK,
                ModBlocks.END_TRAVELERS_BACKPACK,
                ModBlocks.NETHER_TRAVELERS_BACKPACK,
                ModBlocks.SANDSTONE_TRAVELERS_BACKPACK,
                ModBlocks.SNOW_TRAVELERS_BACKPACK,
                ModBlocks.SPONGE_TRAVELERS_BACKPACK,

                ModBlocks.CAKE_TRAVELERS_BACKPACK,

                ModBlocks.CACTUS_TRAVELERS_BACKPACK,
                ModBlocks.HAY_TRAVELERS_BACKPACK,
                ModBlocks.MELON_TRAVELERS_BACKPACK,
                ModBlocks.PUMPKIN_TRAVELERS_BACKPACK,

                ModBlocks.CREEPER_TRAVELERS_BACKPACK,
                ModBlocks.DRAGON_TRAVELERS_BACKPACK,
                ModBlocks.ENDERMAN_TRAVELERS_BACKPACK,
                ModBlocks.BLAZE_TRAVELERS_BACKPACK,
                ModBlocks.GHAST_TRAVELERS_BACKPACK,
                ModBlocks.MAGMA_CUBE_TRAVELERS_BACKPACK,
                ModBlocks.SKELETON_TRAVELERS_BACKPACK,
                ModBlocks.SPIDER_TRAVELERS_BACKPACK,
                ModBlocks.WITHER_TRAVELERS_BACKPACK,
                ModBlocks.WARDEN_TRAVELERS_BACKPACK,

                ModBlocks.BAT_TRAVELERS_BACKPACK,
                ModBlocks.BEE_TRAVELERS_BACKPACK,
                ModBlocks.WOLF_TRAVELERS_BACKPACK,
                ModBlocks.FOX_TRAVELERS_BACKPACK,
                ModBlocks.OCELOT_TRAVELERS_BACKPACK,
                ModBlocks.HORSE_TRAVELERS_BACKPACK,
                ModBlocks.COW_TRAVELERS_BACKPACK,
                ModBlocks.PIG_TRAVELERS_BACKPACK,
                ModBlocks.SHEEP_TRAVELERS_BACKPACK,
                ModBlocks.CHICKEN_TRAVELERS_BACKPACK,
                ModBlocks.SQUID_TRAVELERS_BACKPACK,
                ModBlocks.VILLAGER_TRAVELERS_BACKPACK,
                ModBlocks.IRON_GOLEM_TRAVELERS_BACKPACK).build(null));
    }

    public static void initSidedStorage() {
        FluidStorage.SIDED.registerForBlockEntity(ModBlockEntityTypes::getProperTank, BACKPACK);
        ItemStorage.SIDED.registerForBlockEntity((ModBlockEntityTypes::getProperInventory), BACKPACK);
    }

    public static SingleVariantStorage<FluidVariant> getProperTank(BackpackBlockEntity blockEntity, class_2350 clickedDirection) {
        class_2350 direction = blockEntity.getBlockDirection();
        if(blockEntity.getWrapper() != BackpackWrapper.DUMMY && blockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
            TanksUpgrade tanksUpgrade = blockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
            if(clickedDirection == null) return tanksUpgrade.getLeftTank();

            if(direction == class_2350.field_11043) {
                switch(clickedDirection) {
                    case field_11039:
                        return tanksUpgrade.getRightTank();
                    case field_11034:
                        return tanksUpgrade.getLeftTank();
                }
            }
            if(direction == class_2350.field_11035) {
                switch(clickedDirection) {
                    case field_11034:
                        return tanksUpgrade.getRightTank();
                    case field_11039:
                        return tanksUpgrade.getLeftTank();
                }
            }

            if(direction == class_2350.field_11034) {
                switch(clickedDirection) {
                    case field_11043:
                        return tanksUpgrade.getRightTank();
                    case field_11035:
                        return tanksUpgrade.getLeftTank();
                }
            }

            if(direction == class_2350.field_11039) {
                switch(clickedDirection) {
                    case field_11035:
                        return tanksUpgrade.getRightTank();
                    case field_11043:
                        return tanksUpgrade.getLeftTank();
                }
            }
            return tanksUpgrade.getLeftTank();
        }
        return new FluidTank(0);
    }

    public static class BackpackStorage implements Storage<ItemVariant> {
        private final SlottedStorage<ItemVariant> storage;
        private final StorageAccessWrapper backingStorage;

        public BackpackStorage(StorageAccessWrapper backingStorage) {
            this.storage = InventoryStorage.of(backingStorage, null);
            this.backingStorage = backingStorage;
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_1799 stack = resource.toStack();

            if(backingStorage.tryVoiding(stack)) {
                return maxAmount; //Accept, but void
            }
            long totalInserted = 0;
            long remaining = maxAmount;

            for(Pair<Integer, Pair<class_1799, Boolean>> memorizedStack : backingStorage.wrapper.getMemorySlots()) {
                if(memorizedStack.getSecond().getFirst().method_7909() != stack.method_7909()) {
                    continue;
                }
                int result = matchesStack(stack, memorizedStack);

                if(result == -1) {
                    continue;
                }
                SingleSlotStorage<ItemVariant> slot = storage.getSlot(result);
                long inserted = slot.insert(resource, remaining, transaction);
                if(inserted > 0) {
                    totalInserted += inserted;
                    remaining -= inserted;
                    if(remaining <= 0) {
                        return totalInserted;
                    }
                }
            }

            for(int i = 0; i < storage.getSlotCount() && remaining > 0; i++) {
                if(backingStorage.wrapper.getUnsortableSlots().contains(i)) {
                    continue;
                }
                SingleSlotStorage<ItemVariant> slot = storage.getSlot(i);
                long inserted = slot.insert(resource, remaining, transaction);
                if(inserted > 0) {
                    totalInserted += inserted;
                    remaining -= inserted;
                }
            }
            return totalInserted;
        }

        public int matchesStack(class_1799 inserted, Pair<Integer, Pair<class_1799, Boolean>> memorizedStack) {
            if(memorizedStack.getSecond().getSecond()) {
                return ItemStackUtils.isSameItemSameTags(inserted, memorizedStack.getSecond().getFirst()) ? memorizedStack.getFirst() : -1;
            } else {
                return class_1799.method_7984(inserted, memorizedStack.getSecond().getFirst()) ? memorizedStack.getFirst() : -1;
            }
        }

        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long totalExtracted = 0;
            long remaining = maxAmount;

            for(int i = 0; i < storage.getSlotCount() && remaining > 0; i++) {
                if(backingStorage.wrapper.getUnsortableSlots().contains(i)) {
                    continue;
                }
                SingleSlotStorage<ItemVariant> slot = storage.getSlot(i);
                if(!slot.isResourceBlank() && slot.getResource().equals(resource)) {
                    long extracted = slot.extract(resource, remaining, transaction);
                    if(extracted > 0) {
                        totalExtracted += extracted;
                        remaining -= extracted;
                    }
                }
            }
            return totalExtracted;
        }

        @Override
        public Iterator<StorageView<ItemVariant>> iterator() {
            Iterator<StorageView<ItemVariant>> baseIt = storage.iterator();

            return new Iterator<>() {
                @Override
                public boolean hasNext() {
                    return baseIt.hasNext();
                }

                @Override
                public StorageView<ItemVariant> next() {
                    StorageView<ItemVariant> original = baseIt.next();
                    return new StorageView<ItemVariant>() {
                        @Override
                        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                            int slotIndex = getSlotIndex(original);
                            if(backingStorage.wrapper.getUnsortableSlots().contains(slotIndex)) {
                                return 0;
                            }
                            return original.extract(resource, maxAmount, transaction);
                        }

                        @Override
                        public ItemVariant getResource() {
                            return original.getResource();
                        }

                        @Override
                        public long getAmount() {
                            return original.getAmount();
                        }

                        @Override
                        public long getCapacity() {
                            return original.getCapacity();
                        }

                        @Override
                        public boolean isResourceBlank() {
                            return original.isResourceBlank();
                        }

                        @Override
                        public StorageView<ItemVariant> getUnderlyingView() {
                            return original;
                        }
                    };
                }

                private int getSlotIndex(StorageView<ItemVariant> view) {
                    for(int i = 0; i < storage.getSlotCount(); i++) {
                        if(storage.getSlot(i) == view) {
                            return i;
                        }
                    }
                    return -1;
                }
            };
        }
    }

    public static Storage<ItemVariant> getProperInventory(BackpackBlockEntity blockEntity, class_2350 clickedDirection) {
        if(blockEntity.getWrapper() != BackpackWrapper.DUMMY) {
            return new BackpackStorage(blockEntity.getWrapper().getStorageForInputOutput());
        }
        return InventoryStorageImpl.of(new ItemStackHandler(0), null);
    }
}